/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class ExitTrackableFutureTask<V>
extends FutureTask<V> {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);

    public ExitTrackableFutureTask(Callable<V> callable) {
        super(callable);
    }

    public ExitTrackableFutureTask(Runnable runnable, V result) {
        super(runnable, result);
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    public boolean waitOnRunnableExit(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.countDownLatch.await(timeout, timeUnit);
    }

    public boolean hasExited() {
        return this.countDownLatch.getCount() == 0L;
    }

    @Override
    protected boolean runAndReset() {
        throw new UnsupportedOperationException();
    }
}

