/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.concurrent;

import com.appdynamics.common.util.concurrent.ExitTrackableFutureTask;
import com.appdynamics.common.util.exception.Exceptions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class ConcurrencyHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConcurrencyHelper.class);
    public static final int DEFAULT_EXECUTOR_STOP_WAIT_SECS = 10;
    private static Marker DO_NOT_THROTTLE = MarkerFactory.getMarker((String)"DO_NOT_THROTTLE");

    private ConcurrencyHelper() {
    }

    public static boolean stop(ExecutorService executorService, Logger logger) {
        return ConcurrencyHelper.stop(executorService, 10, logger);
    }

    public static boolean stop(ExecutorService executorService, int waitBeforeTerminateSecs, Logger logger) {
        int waitMillis = Math.max(1000, 1000 * waitBeforeTerminateSecs);
        executorService.shutdown();
        boolean stopped = false;
        while (waitMillis > 0 && !stopped) {
            long startMillis = System.currentTimeMillis();
            try {
                logger.debug(DO_NOT_THROTTLE, "Waiting for thread pool to stop");
                stopped = executorService.awaitTermination(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.debug(DO_NOT_THROTTLE, "Thread was interrupted while it was waiting for thread pool to stop", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
            waitMillis = (int)((long)waitMillis - (System.currentTimeMillis() - startMillis));
        }
        if (!executorService.isTerminated()) {
            logger.warn(DO_NOT_THROTTLE, "Thread pool will be forcibly stopped now if it has not already stopped");
            executorService.shutdownNow();
            try {
                stopped = executorService.awaitTermination(waitBeforeTerminateSecs, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!executorService.isTerminated()) {
                logger.warn(DO_NOT_THROTTLE, "Could not shutdown thread pool in [{}] seconds", (Object)waitBeforeTerminateSecs);
            }
        }
        return stopped;
    }

    public static <T> T getOrCancel(Future<T> future, int waitBeforeCancelSecs, Logger logger) {
        int waitMillis = Math.max(1000, 1000 * waitBeforeCancelSecs);
        while (true) {
            long startMillis = System.currentTimeMillis();
            try {
                if (waitMillis <= 0) {
                    return future.get(1L, TimeUnit.NANOSECONDS);
                }
                logger.debug("Waiting for task to complete");
                return future.get(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Exceptions.rethrowAsRuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwables.propagate((Throwable)e);
            }
            catch (TimeoutException e) {
                logger.debug("Thread timed out while it was waiting for task to complete", (Throwable)e);
            }
            if ((waitMillis = (int)((long)waitMillis - (System.currentTimeMillis() - startMillis))) > 0) continue;
            logger.warn("Task will be forcibly stopped now if it has not already stopped");
            future.cancel(true);
        }
    }

    public static boolean cancelWithWaitOnExit(ExitTrackableFutureTask<?> exitTrackingRunnable, long timeoutMillis) {
        if (exitTrackingRunnable.hasExited()) {
            return true;
        }
        exitTrackingRunnable.cancel(true);
        boolean exited = false;
        try {
            exited = exitTrackingRunnable.waitOnRunnableExit(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Exceptions.rethrowAsRuntimeException(e);
        }
        return exited;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Exceptions.rethrowAsRuntimeException(e);
        }
    }

    public static ThreadFactory newDaemonThreadFactory(String threadFamilyNameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(threadFamilyNameFormat).setDaemon(true).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("Unexpected error occurred on thread [" + t.getName() + "]", e);
            }
        }).build();
    }
}

