/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.charsequence;

import com.appdynamics.common.util.regex.RegexConstants;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class InterruptibleCharSequence
implements CharSequence {
    private long startNanos;
    private int invocationCounter;
    private CharSequence inner;

    public void reinitialize(CharSequence inner) {
        this.inner = inner;
        this.startNanos = System.nanoTime();
        this.invocationCounter = 0;
    }

    @Override
    public char charAt(int index) {
        ++this.invocationCounter;
        this.invocationCounter %= 500;
        if (this.invocationCounter == 1) {
            long timeSpent = System.nanoTime() - this.startNanos;
            if (timeSpent > RegexConstants.TIMEOUT_THRESHOLD_NANOS) {
                throw new RuntimeException(new TimeoutException("The current regex has spent " + TimeUnit.NANOSECONDS.toSeconds(timeSpent) + " seconds attempting to match the log line, further processing has been stopped for this log line."));
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException(new InterruptedException("The current thread has spent " + TimeUnit.NANOSECONDS.toSeconds(timeSpent) + " seconds and was interrupted during regex matching"));
            }
        }
        return this.inner.charAt(index);
    }

    @Override
    public int length() {
        return this.inner.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        InterruptibleCharSequence charSequence = new InterruptibleCharSequence();
        charSequence.reinitialize(this.inner.subSequence(start, end));
        return charSequence;
    }

    @Override
    public String toString() {
        return this.inner.toString();
    }
}

