/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.grok;

import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.grok.GrokLine;
import com.appdynamics.common.util.grok.GrokLineAst;
import com.appdynamics.common.util.grok.GrokParser;
import com.appdynamics.common.util.regex.RegexPattern;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Grok {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Grok.class);
    Map<String, GrokLineAst> namesAndGrokAsts = new TreeMap<String, GrokLineAst>();
    Map<String, GrokLine> namesAndGrokLines = new TreeMap<String, GrokLine>();
    Map<String, String> javaAndGrokAliases = new TreeMap<String, String>();

    public void addFromGrokFiles(List<Path> grokFilePaths) throws IOException {
        TreeMap<String, GrokLineAst> namesAndGrokLine = new TreeMap<String, GrokLineAst>();
        for (Path grokFilePath : grokFilePaths) {
            log.debug("Attempting to parse [{}]", (Object)grokFilePath);
            int before = namesAndGrokLine.size();
            try (FileInputStream fis = new FileInputStream(grokFilePath.toFile());){
                GrokParser.parseLines(fis, namesAndGrokLine);
            }
            int after = namesAndGrokLine.size();
            log.debug("Parsed [{}] and [{}] new patterns were detected", (Object)grokFilePath, (Object)(after - before));
        }
        this.namesAndGrokAsts.putAll((Map<String, GrokLineAst>)ImmutableSortedMap.copyOf(namesAndGrokLine));
        this.namesAndGrokLines.putAll(Grok.resolveAndTransform(this.namesAndGrokAsts));
        this.javaAndGrokAliases.putAll(Grok.extractJavaAndGrokAliases(this.namesAndGrokAsts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFromInputStreams(InputStream ... utf8GrokStreams) throws IOException {
        TreeMap<String, GrokLineAst> namesAndGrokLine = new TreeMap<String, GrokLineAst>();
        int i = 0;
        for (InputStream inputStream : utf8GrokStreams) {
            log.debug("Attempting to parse stream [{}]", (Object)i);
            int before = namesAndGrokLine.size();
            try {
                GrokParser.parseLines(inputStream, namesAndGrokLine);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            int after = namesAndGrokLine.size();
            log.debug("Parsed stream [{}] and [{}] new patterns were detected", (Object)i, (Object)(after - before));
            ++i;
        }
        this.namesAndGrokAsts.putAll((Map<String, GrokLineAst>)ImmutableSortedMap.copyOf(namesAndGrokLine));
        this.namesAndGrokLines.putAll(Grok.resolveAndTransform(this.namesAndGrokAsts));
        this.javaAndGrokAliases.putAll(Grok.extractJavaAndGrokAliases(this.namesAndGrokAsts));
    }

    private static Map<String, GrokLine> resolveAndTransform(Map<String, GrokLineAst> asts) {
        TreeMap<String, GrokLine> namesAndPatterns = new TreeMap<String, GrokLine>();
        for (Map.Entry<String, GrokLineAst> entry : asts.entrySet()) {
            String patternName = entry.getKey();
            try {
                GrokLine grokLine = entry.getValue().resolve(asts);
                log.trace("Resolved pattern [{}] to [{}]", (Object)patternName, (Object)grokLine);
                namesAndPatterns.put(patternName, grokLine);
            }
            catch (RuntimeException e) {
                throw new ConfigurationException("Error occurred while parsing pattern [" + patternName + "]", (Throwable)e);
            }
        }
        return ImmutableSortedMap.copyOf(namesAndPatterns);
    }

    private static Map<String, String> extractJavaAndGrokAliases(Map<String, GrokLineAst> grokLines) {
        HashMap<String, String> javaAliasesAndGrokAliases = new HashMap<String, String>(grokLines.size());
        for (Map.Entry<String, GrokLineAst> entry : grokLines.entrySet()) {
            GrokLineAst grokLineAst = entry.getValue();
            for (GrokLineAst.GrokLineAstItem grokLineAstItem : grokLineAst.getValues()) {
                Optional alias;
                if (!(grokLineAstItem instanceof GrokLineAst.PatternRef) || !(alias = ((GrokLineAst.PatternRef)grokLineAstItem).getAlias()).isPresent()) continue;
                Optional javaAlias = ((GrokLineAst.PatternRef)grokLineAstItem).getAliasJavaCompliant();
                javaAliasesAndGrokAliases.put((String)javaAlias.get(), (String)alias.get());
            }
        }
        return ImmutableMap.copyOf(javaAliasesAndGrokAliases);
    }

    public Set<String> getPatternNames() {
        return this.namesAndGrokLines.keySet();
    }

    public String getPatternNamesAndValue(String key) {
        return this.namesAndGrokLines.get(key).getPatternString();
    }

    public RegexPattern compile(String definition) {
        GrokLineAst grokLineAst = GrokParser.parseDefinition(definition, this.namesAndGrokLines.keySet());
        if (grokLineAst == null) {
            throw new ConfigurationException("The pattern input [" + definition + "] is not a valid Grok definition");
        }
        GrokLine grokLine = grokLineAst.resolve(this.namesAndGrokLines, this.namesAndGrokAsts);
        String tempRandomKey = "tempKey_" + System.nanoTime();
        Map<String, String> javaAndGrokAliasesInDefinition = Grok.extractJavaAndGrokAliases(Collections.singletonMap(tempRandomKey, grokLineAst));
        return grokLine.compile(this.javaAndGrokAliases, javaAndGrokAliasesInDefinition);
    }

    public Map<String, String> getFieldNamesAndAlias(String definition) {
        GrokLineAst grokLineAst = GrokParser.parseDefinition(definition, this.namesAndGrokLines.keySet());
        TreeMap<String, String> fieldNameAndAlias = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (GrokLineAst.GrokLineAstItem grokLineAstItem : grokLineAst.getValues()) {
            Optional alias;
            if (!(grokLineAstItem instanceof GrokLineAst.PatternRef) || !(alias = ((GrokLineAst.PatternRef)grokLineAstItem).getAlias()).isPresent()) continue;
            Optional javaAlias = ((GrokLineAst.PatternRef)grokLineAstItem).getAliasJavaCompliant();
            fieldNameAndAlias.put(((GrokLineAst.PatternRef)grokLineAstItem).getPatternName(), (String)javaAlias.get());
        }
        return fieldNameAndAlias;
    }
}

