/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.io.payload;

import com.google.common.hash.Hashing;
import java.util.Arrays;
import lombok.Generated;

public class Bytes {
    final byte[] array;
    final int offset;
    final int length;

    public Bytes(byte[] array) {
        this(array, 0, array.length);
    }

    public Bytes(byte[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public String contentHash() {
        return Bytes.contentHash(this.array, this.offset, this.length);
    }

    public byte[] getOrCopyArray() {
        return this.offset == 0 && this.length == this.array.length ? this.array : Arrays.copyOfRange(this.array, this.offset, this.offset + this.length);
    }

    public static String contentHash(byte[] array, int offset, int length) {
        return Hashing.murmur3_32().newHasher().putBytes(array, offset, length).hash().toString();
    }

    @Generated
    public byte[] getArray() {
        return this.array;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public int getLength() {
        return this.length;
    }
}

