/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.io;

import com.appdynamics.common.io.file.FilePathConfiguration;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class IoHelper {
    public static final String PREFIX_GLOB = "glob:";
    private static final boolean IS_FILE_SYSTEM_CASE_SENSITIVE = !new File("a").equals(new File("A"));
    private static final String GLOB_PATH_SEPARATOR = "/";

    private IoHelper() {
    }

    public static List<HostAndPort> parseHostAndPortCsv(String csvList) {
        return IoHelper.parseHostAndPortCsv(csvList, new Function<HostAndPort, HostAndPort>(){

            public HostAndPort apply(@Nullable HostAndPort input) {
                if (input == null) {
                    return null;
                }
                if (input.getHost().equals("0.0.0.0")) {
                    return HostAndPort.fromParts((String)"localhost", (int)input.getPort());
                }
                return input;
            }
        });
    }

    public static List<HostAndPort> parseHostAndPortCsv(String csvList, Function<HostAndPort, HostAndPort> rewriter) {
        Iterable items = Splitter.on((char)',').omitEmptyStrings().split((CharSequence)csvList);
        LinkedList<HostAndPort> hostAndPorts = new LinkedList<HostAndPort>();
        for (String item : items) {
            HostAndPort hp = HostAndPort.fromString((String)item);
            if ((hp = (HostAndPort)rewriter.apply((Object)hp)) == null) continue;
            hostAndPorts.add(hp);
        }
        return hostAndPorts;
    }

    public static List<Path> findMatchingPaths(Path dir, final PathMatcher pathMatcher) throws IOException {
        final LinkedList<Path> matchingPaths = new LinkedList<Path>();
        SimpleFileVisitor<Path> matcherVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes baf) {
                if (pathMatcher.matches(file.getFileName())) {
                    matchingPaths.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(dir, (FileVisitor<? super Path>)matcherVisitor);
        return matchingPaths;
    }

    public static boolean isDefaultFileSystemCaseSensitive() {
        return IS_FILE_SYSTEM_CASE_SENSITIVE;
    }

    public static String getGlobPatternFromPathGlob(FilePathConfiguration filePath) {
        return IoHelper.getGlobPatternFromPathGlob(filePath.getPath(), filePath.getNameGlob());
    }

    public static String getGlobPatternFromPathGlob(String path, String glob) {
        return String.format("glob:%s%s%s", StringUtils.stripEnd((String)path.replace('\\', '/'), (String)"\\/"), GLOB_PATH_SEPARATOR, Objects.toString(glob, "").replace('\\', '/'));
    }

    public static boolean checkRecursiveDirSearch(String globPattern, boolean windowsOs) {
        int startOfWildcard;
        Preconditions.checkArgument((boolean)globPattern.startsWith(PREFIX_GLOB));
        int wildcardIndex = globPattern.indexOf("**");
        if (wildcardIndex >= 0) {
            return true;
        }
        wildcardIndex = globPattern.indexOf(42);
        if (wildcardIndex >= 0) {
            if (globPattern.indexOf(47, wildcardIndex) >= 0) {
                return true;
            }
            if (windowsOs && globPattern.indexOf(92, wildcardIndex) >= 0) {
                return true;
            }
        }
        if ((wildcardIndex = globPattern.indexOf(63)) >= 0) {
            if (globPattern.indexOf(47, wildcardIndex) >= 0) {
                return true;
            }
            if (windowsOs && globPattern.indexOf(92, wildcardIndex) >= 0) {
                return true;
            }
        }
        if ((startOfWildcard = globPattern.indexOf(123)) >= 0 && (wildcardIndex = globPattern.indexOf(125, startOfWildcard)) >= 0) {
            if (globPattern.indexOf(47, wildcardIndex) >= 0) {
                return true;
            }
            if (windowsOs && globPattern.indexOf(92, wildcardIndex) >= 0) {
                return true;
            }
        }
        return false;
    }

    public static Path createOsSpecificPath(String fileName) {
        Path filePath;
        if (SystemUtils.IS_OS_WINDOWS) {
            fileName = FilenameUtils.getPath((String)fileName);
            filePath = Paths.get(fileName, new String[0]);
        } else {
            filePath = Paths.get(fileName, new String[0]).getParent();
        }
        return filePath;
    }
}

