/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.feature;

import com.appdynamics.common.framework.version.CalendarVersion;
import com.appdynamics.common.framework.version.CalendarVersionComparator;
import com.appdynamics.common.framework.version.Version;
import com.appdynamics.common.util.feature.Feature;
import com.appdynamics.common.util.feature.Features;
import com.appdynamics.common.util.feature.SimpleFeature;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SimpleFeatures
implements Features {
    private final CalendarVersion systemVersion;
    private final CalendarVersionComparator versionComparator;

    public SimpleFeatures(String systemVersionText) {
        this.systemVersion = new CalendarVersion(systemVersionText);
        this.versionComparator = new CalendarVersionComparator();
    }

    @Override
    public Version systemVersion() {
        return this.systemVersion;
    }

    @Override
    public Feature feature(String featureName, String enabledSinceVersionText) {
        CalendarVersion enabledSince = new CalendarVersion(enabledSinceVersionText);
        boolean enabledNow = this.versionComparator.compare(this.systemVersion, enabledSince) >= 0;
        return new SimpleFeature(featureName, enabledSince, enabledNow);
    }
}

