/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.io.file;

import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.io.FileFilterPathMatcher;
import com.appdynamics.common.io.file.FilePathConfiguration;
import com.appdynamics.common.io.file.FilePollerConfiguration;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilePollerModule<F extends FilePollerConfiguration>
extends Module<F> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractFilePollerModule.class);
    protected volatile FileAlterationMonitor monitor;

    @Override
    public void configure() {
        super.configure();
        long millis = ((FilePollerConfiguration)this.getConfiguration()).getPoll().toMilliseconds();
        FileAlterationMonitor fam = new FileAlterationMonitor(millis);
        fam.setThreadFactory(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.getUri() + "-poller-thread-%d").build());
        this.monitor = fam;
    }

    protected abstract FileAlterationListener newListener(String var1, PathMatcher var2);

    @PostConstruct
    protected void onStart() {
        log.debug("Starting [{}]", (Object)this.getUri());
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        List pathConfigs = ((FilePollerConfiguration)this.getConfiguration()).getPaths();
        for (FilePathConfiguration pathConfig : pathConfigs) {
            File pathDir = new File(pathConfig.getPath());
            if (!pathDir.exists()) {
                throw new IllegalArgumentException("Directory [" + pathDir.getAbsolutePath() + "] that is supposed to be monitored by [" + this.getUri() + "] does not exist");
            }
            String path = pathDir.getAbsolutePath();
            log.info("Directory [{}] with files matching [{}] will be monitored by [{}]", new Object[]{path, pathConfig.getNameGlob(), this.getUri()});
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pathConfig.getNameGlob());
            FileFilterPathMatcher ffpm = new FileFilterPathMatcher(matcher);
            FileAlterationObserver observer = new FileAlterationObserver(path, (FileFilter)ffpm);
            FileAlterationListener listener = this.newListener(path, matcher);
            observer.addListener(listener);
            this.monitor.addObserver(observer);
        }
        log.debug("Started [{}]", (Object)this.getUri());
    }

    @PreDestroy
    protected void stop() {
        log.debug("Stopping [{}]", (Object)this.getUri());
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        log.debug("Stopped [{}]", (Object)this.getUri());
    }
}

