/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework.util;

import java.security.Permission;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedModeSecurityManager
extends SecurityManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedModeSecurityManager.class);
    private static final String EMBEDDED_MODE_SECURITY_MANAGER_CLASS_NAME = EmbeddedModeSecurityManager.class.getName();
    private final SecurityManager optOldSecurityManager;
    private final String[] disallowedPackages;

    EmbeddedModeSecurityManager(SecurityManager optOldSecurityManager, String[] disallowedPackages) {
        this.optOldSecurityManager = optOldSecurityManager;
        this.disallowedPackages = disallowedPackages;
    }

    public static void installSecurityManager(String ... disallowedPackages) {
        SecurityManager oldSecurityManager = System.getSecurityManager();
        if (!(oldSecurityManager instanceof EmbeddedModeSecurityManager)) {
            EmbeddedModeSecurityManager securityManager = new EmbeddedModeSecurityManager(oldSecurityManager, disallowedPackages);
            System.setSecurityManager(securityManager);
            log.debug("Installed");
        }
    }

    @Override
    public void checkExit(int status) {
        StackTraceElement[] elements;
        log.debug("Shutdown request from [" + Thread.currentThread().getName() + "]", new Throwable());
        for (StackTraceElement element : elements = Thread.currentThread().getStackTrace()) {
            String s = element.toString();
            for (String disallowedPackage : this.disallowedPackages) {
                if (!s.contains(disallowedPackage) || s.contains(EMBEDDED_MODE_SECURITY_MANAGER_CLASS_NAME)) continue;
                log.debug("Shutdown request suppressed as the thread stack contains [{}]", (Object)disallowedPackage);
                throw new SuppressedSystemExitException();
            }
        }
        if (this.optOldSecurityManager != null) {
            this.optOldSecurityManager.checkExit(status);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.optOldSecurityManager != null) {
            this.optOldSecurityManager.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.optOldSecurityManager != null) {
            this.optOldSecurityManager.checkPermission(perm, context);
        }
    }

    static class SuppressedSystemExitException
    extends SecurityException {
        SuppressedSystemExitException() {
            super("System exit cannot be performed here as the application is running in embedded mode");
        }
    }
}

