/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.log.throttle;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.appdynamics.common.framework.Constants;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.log.ForwardingAppender;
import com.appdynamics.common.util.log.throttle.DefaultThrottler;
import com.appdynamics.common.util.log.throttle.Throttler;
import java.util.Set;

public class ThrottlingAppender
extends ForwardingAppender {
    private final Throttler throttler;

    public ThrottlingAppender(Appender<ILoggingEvent> delegate, int maxThrottledEvents, int summaryThreshold, int summaryWarnThreshold, TimeUnitConfiguration throttledTime, Set<String> templateThrottledExceptions) {
        super(delegate);
        this.throttler = new DefaultThrottler(delegate, maxThrottledEvents, summaryThreshold, summaryWarnThreshold, throttledTime, templateThrottledExceptions);
    }

    @Override
    public void doAppend(ILoggingEvent loggingEvent) {
        this.throttleOrAppend(loggingEvent);
    }

    protected void append(ILoggingEvent loggingEvent) {
        this.throttleOrAppend(loggingEvent);
    }

    private void throttleOrAppend(ILoggingEvent loggingEvent) {
        if (Constants.DO_NOT_THROTTLE == loggingEvent.getMarker()) {
            this.delegate.doAppend((Object)loggingEvent);
        } else {
            this.throttler.throttle(loggingEvent);
        }
    }

    void flush() {
        this.throttler.flush();
    }

    void close() {
        this.throttler.close();
    }
}

