/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.log;

import org.slf4j.Logger;

public enum LogLevel {
    TRACE,
    DEBUG,
    INFO,
    WARN,
    ERROR;


    public void write(Logger logger, String msg, String ... args) {
        switch (this) {
            case TRACE: {
                logger.trace(msg, (Object[])args);
                break;
            }
            case DEBUG: {
                logger.debug(msg, (Object[])args);
                break;
            }
            case INFO: {
                logger.info(msg, (Object[])args);
                break;
            }
            case WARN: {
                logger.warn(msg, (Object[])args);
                break;
            }
            case ERROR: {
                logger.error(msg, (Object[])args);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level [" + String.valueOf((Object)this) + "]");
            }
        }
    }

    public void write(Logger logger, String msg) {
        switch (this) {
            case TRACE: {
                logger.trace(msg);
                break;
            }
            case DEBUG: {
                logger.debug(msg);
                break;
            }
            case INFO: {
                logger.info(msg);
                break;
            }
            case WARN: {
                logger.warn(msg);
                break;
            }
            case ERROR: {
                logger.error(msg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level [" + String.valueOf((Object)this) + "]");
            }
        }
    }

    public boolean isEnabled(Logger logger) {
        switch (this) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException("Unknown log level [" + String.valueOf((Object)this) + "]");
    }
}

