/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.instrument.registry;

import com.appdynamics.common.util.instrument.Metric;
import com.appdynamics.common.util.instrument.metrics.Counter;
import com.appdynamics.common.util.instrument.metrics.Gauge;
import com.appdynamics.common.util.instrument.metrics.Histogram;
import com.appdynamics.common.util.instrument.metrics.Meter;
import com.appdynamics.common.util.instrument.metrics.Timer;
import com.appdynamics.common.util.instrument.metrics.appd.ADCounter;
import com.appdynamics.common.util.instrument.metrics.appd.ADGauge;
import com.appdynamics.common.util.instrument.metrics.appd.ADHistogram;
import com.appdynamics.common.util.instrument.metrics.appd.ADMeter;
import com.appdynamics.common.util.instrument.metrics.appd.ADTimer;
import com.appdynamics.common.util.instrument.registry.MetricsRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADMetricsRegistry
implements MetricsRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ADMetricsRegistry.class);
    private final ConcurrentMap<String, Metric> metrics = new ConcurrentHashMap<String, Metric>();

    @Override
    public Counter counter(String name) {
        return this.getOrAdd(name, MetricBuilder.COUNTERS);
    }

    @Override
    public Histogram histogram(String name) {
        return this.getOrAdd(name, MetricBuilder.HISTOGRAMS);
    }

    @Override
    public Meter meter(String name) {
        return this.getOrAdd(name, MetricBuilder.METERS);
    }

    @Override
    public Timer timer(String name) {
        return this.getOrAdd(name, MetricBuilder.TIMERS);
    }

    @Override
    public Gauge gauge(String name) {
        return this.getOrAdd(name, MetricBuilder.GAUGES);
    }

    private <T extends Metric> T getOrAdd(String name, MetricBuilder<T> builder) {
        Metric metric = (Metric)this.metrics.get(name);
        if (builder.isInstance(metric)) {
            return (T)metric;
        }
        if (metric == null) {
            T newMetric = builder.newMetric(name);
            Metric prevMetric = this.metrics.putIfAbsent(name, (Metric)newMetric);
            if (prevMetric != null) {
                return (T)prevMetric;
            }
            log.info("Registering the metric [{}]", (Object)name);
            return newMetric;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    private static interface MetricBuilder<T extends Metric> {
        public static final MetricBuilder<Counter> COUNTERS = new MetricBuilder<Counter>(){

            @Override
            public Counter newMetric(String name) {
                return new ADCounter(name);
            }

            @Override
            public boolean isInstance(Metric metric) {
                return ADCounter.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Histogram> HISTOGRAMS = new MetricBuilder<Histogram>(){

            @Override
            public Histogram newMetric(String name) {
                return new ADHistogram(name);
            }

            @Override
            public boolean isInstance(Metric metric) {
                return ADHistogram.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Meter> METERS = new MetricBuilder<Meter>(){

            @Override
            public Meter newMetric(String name) {
                return new ADMeter(name);
            }

            @Override
            public boolean isInstance(Metric metric) {
                return ADMeter.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Timer> TIMERS = new MetricBuilder<Timer>(){

            @Override
            public Timer newMetric(String name) {
                return new ADTimer(name);
            }

            @Override
            public boolean isInstance(Metric metric) {
                return ADTimer.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Gauge> GAUGES = new MetricBuilder<Gauge>(){

            @Override
            public Gauge newMetric(String name) {
                return new ADGauge(name);
            }

            @Override
            public boolean isInstance(Metric metric) {
                return ADGauge.class.isInstance(metric);
            }
        };

        public T newMetric(String var1);

        public boolean isInstance(Metric var1);
    }
}

