/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.instrument.metrics.appd;

import com.appdynamics.common.util.instrument.ADCustomMetric;
import com.appdynamics.common.util.instrument.ADMetric;
import com.appdynamics.common.util.instrument.ADMetricReporter;
import com.appdynamics.common.util.instrument.metrics.Histogram;
import com.appdynamics.sdk.ADAppAgent;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;

public class ADHistogram
implements Histogram {
    private static final String MEAN = "|mean";
    private static final String P75 = "|p75";
    private static final String P95 = "|p95";
    private static final String P99 = "|p99";
    private final String name;
    private final ADMetric p75;
    private final ADMetric p95;
    private final ADMetric p99;
    private final ADMetric mean;
    private final com.codahale.metrics.Histogram histogram;
    private final LoadingCache<String, Snapshot> cache;
    private final ADMetricReporter ADreporter;

    public ADHistogram(String metricName) {
        this.name = metricName;
        this.mean = this.createADMetric(this.name + MEAN);
        this.p75 = this.createADMetric(this.name + P75);
        this.p95 = this.createADMetric(this.name + P95);
        this.p99 = this.createADMetric(this.name + P99);
        this.cache = this.createSnapshotCache();
        this.ADreporter = ADMetricReporter.INSTANCE;
        this.histogram = new com.codahale.metrics.Histogram((Reservoir)new ExponentiallyDecayingReservoir());
    }

    @Override
    public void update(long value) {
        this.histogram.update(value);
        Snapshot snapshot = (Snapshot)this.cache.getUnchecked((Object)this.name);
        this.ADreporter.report(this.p75, Math.round(snapshot.get75thPercentile()));
        this.ADreporter.report(this.p95, Math.round(snapshot.get95thPercentile()));
        this.ADreporter.report(this.p99, Math.round(snapshot.get99thPercentile()));
        this.ADreporter.report(this.mean, value);
    }

    private ADMetric createADMetric(String name) {
        return ADCustomMetric.builder().name(name).aggregationType(ADAppAgent.MetricAggregatorType.AVERAGE).timeRollupType(ADAppAgent.MetricTimeRollupType.AVERAGE).clusterRollupType(ADAppAgent.MetricClusterRollupType.INDIVIDUAL).build();
    }

    private LoadingCache<String, Snapshot> createSnapshotCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Snapshot>(){

            public Snapshot load(String key) throws Exception {
                return ADHistogram.this.histogram.getSnapshot();
            }
        });
    }
}

