/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.codahale.metrics.health.HealthCheck;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;

public class QueueCapacityHealthCheck
extends SimpleHealthCheck {
    final double unhealthyRatio;
    final ConcurrentMap<?, BlockingQueue<?>> queues;

    public QueueCapacityHealthCheck(String name, double unhealthyRatio, ConcurrentMap<?, BlockingQueue<?>> queues) {
        super(name);
        this.unhealthyRatio = unhealthyRatio;
        this.queues = queues;
    }

    @Override
    public HealthCheck.Result check() {
        int totalNum = 0;
        int almostFullNum = 0;
        TreeSet<String> allNames = new TreeSet<String>();
        for (Map.Entry entry : this.queues.entrySet()) {
            BlockingQueue queue = (BlockingQueue)entry.getValue();
            int size = queue.size();
            String qName = String.valueOf(entry.getKey());
            int capacity = size + queue.remainingCapacity();
            double ratio = (double)size / (double)capacity;
            if (ratio >= this.unhealthyRatio) {
                ++almostFullNum;
            }
            allNames.add(String.format("[%s] ratio: [%.2f], size: [%d], capacity: [%d]", qName, ratio, size, capacity));
            ++totalNum;
        }
        if (almostFullNum == 0) {
            return HealthCheck.Result.healthy((String)String.format("[%d] queues %s", totalNum, allNames));
        }
        return HealthCheck.Result.unhealthy((String)String.format("[%d] out of [%d] queues are above [%.2f] capacity: %s", almostFullNum, totalNum, this.unhealthyRatio, allNames));
    }

    @Generated
    public double getUnhealthyRatio() {
        return this.unhealthyRatio;
    }
}

