/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import java.text.NumberFormat;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class PrecisionFormatter {
    private static final int DEFAULT_PRECISION_LENGTH = 6;
    private static final double DEFAULT_SMALLEST_VISIBLE_RATE = 1.0 / Math.pow(10.0, 6.0);
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance();

    private PrecisionFormatter() {
    }

    public static String format(double rawValue) {
        double truncatedValue = PrecisionFormatter.truncateRate(rawValue);
        return numberFormat.format(truncatedValue);
    }

    public static double truncateRate(double d) {
        return d < DEFAULT_SMALLEST_VISIBLE_RATE ? 0.0 : d;
    }

    static {
        numberFormat.setMaximumFractionDigits(6);
        numberFormat.setMinimumFractionDigits(6);
    }
}

