/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import com.appdynamics.common.framework.AppConfiguration;
import com.appdynamics.common.framework.AppInfo;
import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.configuration.Parameters;
import com.appdynamics.common.util.health.HealthReport;
import com.appdynamics.common.util.health.HealthReporterModuleConfiguration;
import com.appdynamics.common.util.log.LogLevel;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import io.dropwizard.core.setup.Environment;
import java.lang.management.ManagementFactory;
import java.util.AbstractMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthReporterModule
extends Module<HealthReporterModuleConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthReporterModule.class);
    public static final String REPORT_HEALTHY = "Report healthy";
    public static final String REPORT_UNHEALTHY = "Report unhealthy";
    public static final String MBEAN_NAME = "Application:name=Health report";
    private final ExecutorService executorService;
    private volatile HealthReport healthReport;
    private volatile Future<?> loggerTask;

    public HealthReporterModule() {
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(true).setPriority(1).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("Error occurred while reporting health on thread [" + t.getName() + "]. Health reports will not function any more", e);
            }
        }).setNameFormat("health-report-thread-%d").build();
        this.executorService = Executors.newSingleThreadExecutor(tf);
    }

    @Inject
    void start(AppConfiguration configuration, AppInfo appInfo, Environment environment) {
        this.healthReport = new HealthReport(configuration.getName(), appInfo.toString(), true);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this.healthReport, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            log.warn("Error occurred while registering MBean", (Throwable)e);
        }
        final HealthCheckRegistry registry = environment.healthChecks();
        TimeUnit waitTimeUnit = ((HealthReporterModuleConfiguration)this.getConfiguration()).getSchedule().getTimeUnit();
        final long waitTimeMillis = waitTimeUnit.toMillis(((HealthReporterModuleConfiguration)this.getConfiguration()).getSchedule().getTime());
        this.loggerTask = this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(waitTimeMillis);
                    }
                    catch (InterruptedException e) {
                        log.debug("Task has been interrupted and will exit", (Throwable)e);
                        Thread.currentThread().interrupt();
                        return;
                    }
                    Map.Entry<HealthCheck.Result, String> entry = HealthReporterModule.this.runCheckAndLog(registry);
                    HealthReporterModule.this.healthReport.setHealthy(entry.getKey().isHealthy());
                }
            }
        });
        log.info("Started and is scheduled to run every [{} {}]", (Object)((HealthReporterModuleConfiguration)this.getConfiguration()).getSchedule().getTime(), (Object)waitTimeUnit);
    }

    Map.Entry<HealthCheck.Result, String> runCheckAndLog(HealthCheckRegistry registry) {
        log.debug("Starting scheduled health check");
        SortedMap results = registry.runHealthChecks();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        boolean healthy = true;
        for (Map.Entry entry : results.entrySet()) {
            sb.append(i > 0 ? "\n\n" : "");
            sb.append((String)entry.getKey()).append(": ");
            HealthCheck.Result result = (HealthCheck.Result)entry.getValue();
            String msg = result.getMessage();
            sb.append(result.isHealthy() ? "(healthy)" : "(unhealthy)").append(' ').append(Parameters.asString((Object)msg, (String)""));
            Throwable t = result.getError();
            if (t != null) {
                sb.append("\n").append(Throwables.getStackTraceAsString((Throwable)t));
            }
            healthy = healthy && result.isHealthy();
            ++i;
        }
        String message = sb.toString();
        if (healthy) {
            LogLevel logLevel = ((HealthReporterModuleConfiguration)this.getConfiguration()).getHealthyLogLevel();
            logLevel.write(log, "Report healthy [\n" + message + "\n]");
        } else {
            log.warn("Report unhealthy [\n{}\n]", (Object)message);
        }
        return new AbstractMap.SimpleImmutableEntry<HealthCheck.Result, String>(healthy ? HealthCheck.Result.healthy() : HealthCheck.Result.unhealthy((String)""), message);
    }

    @PreDestroy
    void stop() {
        if (this.loggerTask != null) {
            try {
                ConcurrencyHelper.getOrCancel(this.loggerTask, (int)1, (Logger)log);
            }
            catch (RuntimeException e) {
                log.trace("Task was stopped", (Throwable)e);
            }
        }
        ConcurrencyHelper.stop((ExecutorService)this.executorService, (Logger)log);
        log.info("Stopped");
    }
}

