/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.configuration.property.DynamicTimeUnitConfiguration;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.lifecycle.LifecycleAware;
import com.codahale.metrics.health.HealthCheck;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import lombok.NonNull;
import org.slf4j.Logger;

public abstract class AsynchronousHealthCheckable
extends HealthCheck
implements HealthCheckable,
LifecycleAware {
    @NonNull
    private final ScheduledExecutorService scheduler;
    @NonNull
    private final DynamicTimeUnitConfiguration delayBetweenExecutions;
    private volatile HealthCheck.Result healthCheckResult;
    private volatile ScheduledFuture<?> scheduledFuture;

    protected AsynchronousHealthCheckable(@NonNull DynamicTimeUnitConfiguration delayBetweenExecutions) {
        if (delayBetweenExecutions == null) {
            throw new IllegalArgumentException("delayBetweenExecutions is marked non-null but is null");
        }
        this.delayBetweenExecutions = delayBetweenExecutions;
        this.delayBetweenExecutions.addCallback(new Runnable(){

            @Override
            public void run() {
                AsynchronousHealthCheckable.this.scheduleUpdateTask();
            }
        });
        String nameFormat = this.getClass().getName();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(ConcurrencyHelper.newDaemonThreadFactory((String)nameFormat));
    }

    public void start() {
        this.runUpdateHealthCheckResult();
        this.scheduleUpdateTask();
    }

    public void stop() {
        ConcurrencyHelper.stop((ExecutorService)this.scheduler, (Logger)this.getLogger());
    }

    @Override
    public final HealthCheck.Result check() {
        return this.healthCheckResult;
    }

    protected HealthCheck.Result createFailureHealthCheckResult(@NonNull Exception cause) {
        if (cause == null) {
            throw new IllegalArgumentException("cause is marked non-null but is null");
        }
        return HealthCheck.Result.unhealthy((Throwable)cause);
    }

    protected abstract Logger getLogger();

    protected abstract HealthCheck.Result updateHealthCheckResult() throws InterruptedException;

    private void runUpdateHealthCheckResult() {
        try {
            this.healthCheckResult = this.updateHealthCheckResult();
            this.getLogger().debug("Health check value updated: healthCheckResult=[{}]", (Object)this.healthCheckResult);
        }
        catch (InterruptedException ignored) {
            this.getLogger().debug("Health check interrupted.");
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.healthCheckResult = this.createFailureHealthCheckResult(e);
            this.getLogger().debug("Health check update failed: healthCheckResult=[{}]", (Object)this.healthCheckResult, (Object)e);
        }
    }

    private synchronized void scheduleUpdateTask() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.getLogger().info("Previous task cancelled.");
        }
        TimeUnitConfiguration currDelay = this.delayBetweenExecutions.get();
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                AsynchronousHealthCheckable.this.runUpdateHealthCheckResult();
            }
        }, currDelay.getTime(), currDelay.getTime(), currDelay.getTimeUnit());
        this.getLogger().info("Scheduled async health update task: delayBetweenExecutions=[{}]", (Object)currDelay);
    }
}

