/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.event;

import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.event.EventBusConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBuses {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventBuses.class);
    public static final String NAME_DEFAULT_EVENT_BUS = "default-event-bus";
    final Map<String, EventBus> eventBuses = new HashMap<String, EventBus>();
    final List<ExecutorService> executorServices = new ArrayList<ExecutorService>();

    EventBuses(List<EventBusConfiguration> busConfigurations) {
        for (EventBusConfiguration bc : busConfigurations) {
            EventBus eventBus = null;
            if (bc.isAsync()) {
                String poolName = "async-event-bus-" + bc.getName() + "-%d";
                ExecutorService es = Executors.newSingleThreadExecutor(ConcurrencyHelper.newDaemonThreadFactory((String)poolName));
                eventBus = new AsyncEventBus((Executor)es, (SubscriberExceptionHandler)new SubscriptionHandlingLogger(bc.getName()));
                this.executorServices.add(es);
            } else {
                eventBus = new EventBus((SubscriberExceptionHandler)new SubscriptionHandlingLogger(bc.getName()));
            }
            EventBus oldBus = this.eventBuses.put(bc.getName(), eventBus);
            if (oldBus != null) {
                throw new ConfigurationException("There is more than one channel configured with the same name [" + bc.getName() + "]");
            }
            log.info("Started event bus [{}]", (Object)bc.getName());
        }
    }

    EventBus findEventBus(String eventBusName) {
        EventBus eventBus = this.eventBuses.get(eventBusName);
        Preconditions.checkArgument((eventBus != null ? 1 : 0) != 0, (Object)("The event bus [" + eventBusName + "] does not exist"));
        return eventBus;
    }

    public void registerListener(String eventBusName, Object listener) {
        EventBus eventBus = this.findEventBus(eventBusName);
        eventBus.register(listener);
        log.debug("Registered [{}] with event bus [{}]", listener, (Object)eventBusName);
    }

    public void postEvent(String eventBusName, Object event) {
        EventBus eventBus = this.findEventBus(eventBusName);
        log.debug("Posting event [{}] to event bus [{}]", event, (Object)eventBusName);
        eventBus.post(event);
    }

    public void unregisterListener(String eventBusName, Object listener) {
        EventBus eventBus = this.findEventBus(eventBusName);
        eventBus.unregister(listener);
        log.debug("Unregistered [{}] from event bus [{}]", listener, (Object)eventBusName);
    }

    @PreDestroy
    void onStop() {
        log.debug("Stopping");
        for (ExecutorService executorService : this.executorServices) {
            ConcurrencyHelper.stop((ExecutorService)executorService, (int)1, (Logger)log);
        }
        log.info("Stopped");
    }

    static class SubscriptionHandlingLogger
    implements SubscriberExceptionHandler {
        final Logger logger;

        SubscriptionHandlingLogger(String name) {
            this.logger = LoggerFactory.getLogger((String)(EventBus.class.getSimpleName() + "-" + name));
        }

        public void handleException(Throwable throwable, SubscriberExceptionContext context) {
            this.logger.error("An error occurred while dispatching event [" + String.valueOf(context.getSubscriber()) + "] to [" + String.valueOf(context.getSubscriberMethod()) + "]", throwable);
        }
    }
}

