/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework.util;

import com.appdynamics.common.framework.AbstractApp;
import com.appdynamics.common.framework.AppConfiguration;
import com.appdynamics.common.framework.util.ClickJackSecurityFilter;
import com.appdynamics.common.framework.util.FrameworkHelper;
import com.appdynamics.common.framework.util.NoOpResource;
import com.google.common.base.Optional;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.setup.Environment;
import jakarta.servlet.DispatcherType;
import java.util.EnumSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleApp<C extends AppConfiguration>
extends AbstractApp<C> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleApp.class);

    public SimpleApp(boolean embeddedMode) {
        super(embeddedMode);
    }

    public SimpleApp() {
    }

    @Override
    protected final AbstractApp.LazyCommand makeCommand() {
        return new AbstractApp.LazyCommand("server", (Optional<? extends Command>)Optional.absent());
    }

    @Override
    protected void beforeModuleLoading(C conf, Environment env) {
        FrameworkHelper.recordHttpServerPort(env);
        if (!this.isEmbeddedMode()) {
            FrameworkHelper.createPidFile(((AppConfiguration)((Object)conf)).getName());
        }
        FrameworkHelper.startJmxReporter(env);
        if (this.isPrometheusMetricsEnabled()) {
            FrameworkHelper.registerAndExposePrometheusMetrics(env);
        }
        FrameworkHelper.addLifecycleLogger(conf, env, log);
        env.setValidator(FrameworkHelper.buildCustomValidator(conf));
        env.servlets().addFilter(ClickJackSecurityFilter.class.getSimpleName(), ClickJackSecurityFilter.class).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        env.admin().addFilter(ClickJackSecurityFilter.class.getSimpleName(), ClickJackSecurityFilter.class).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        env.jersey().register(NoOpResource.class);
    }

    private boolean isPrometheusMetricsEnabled() {
        return this.configurationProperties == null ? Boolean.getBoolean("ad.metrics.prometheus.enabled") : this.configurationProperties.getBoolean("ad.metrics.prometheus.enabled", Boolean.FALSE.booleanValue());
    }
}

