/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework.util;

import com.appdynamics.common.util.var.SystemVariableResolver;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import io.dropwizard.servlets.tasks.Task;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownTask
extends Task {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShutdownTask.class);
    public static final String NAME = "shutdown";
    public static final String PARAM = "captcha";
    private final String expectedCaptcha = ShutdownTask.makeCaptcha();

    public ShutdownTask() {
        super(NAME);
    }

    private static String makeCaptcha() {
        long pid = SystemVariableResolver.getProcessId();
        return ShutdownTask.makeCaptcha(pid);
    }

    public static String makeCaptcha(long pid) {
        BigInteger pidBig = BigInteger.valueOf(pid);
        String base16 = pidBig.toString(16).toUpperCase();
        String base32 = pidBig.toString(32).toUpperCase();
        return String.format("%d-%s-%s", pid, base16, base32);
    }

    public void execute(Map<String, List<String>> parameters, PrintWriter output) {
        log.info("Shutdown requested with parameters {}", parameters);
        List<String> values = parameters.get(PARAM);
        if (values != null && values.size() == 1) {
            String value = (String)Iterators.getLast(values.iterator());
            if (this.expectedCaptcha.equals(value = Strings.nullToEmpty((String)value))) {
                log.warn("This process will shutdown soon");
                output.close();
                new Thread(((Object)((Object)this)).getClass().getSimpleName() + "-shutdown-invoker"){

                    @Override
                    public void run() {
                        ShutdownTask.this.shutdown();
                    }
                }.start();
                return;
            }
        }
        log.warn("Shutdown request was ignored");
        throw new RuntimeException("Request denied");
    }

    private void shutdown() {
        System.exit(0);
    }
}

