/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework;

import com.appdynamics.common.framework.AppConfiguration;
import com.appdynamics.common.framework.AppLifecycle;
import com.appdynamics.common.framework.BootstrapModule;
import com.appdynamics.common.framework.Configurable;
import com.appdynamics.common.framework.ModuleConfiguration;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.configuration.Reader;
import com.appdynamics.common.util.configuration.property.ConfigurationProperties;
import com.appdynamics.common.util.lifecycle.Stoppable;
import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.InstanceBinding;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Loaders {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Loaders.class);

    private Loaders() {
    }

    static void loadAndAddBundles(Bootstrap<? extends AppConfiguration> bootstrap) {
        String csv = System.getProperty("ad.dw.bundle.classNames.csv");
        if (csv == null || (csv = csv.trim()).length() <= 0) {
            log.debug("No bundles to load");
            return;
        }
        log.debug("Attempting to load bundles [{}]", (Object)csv);
        String[] classNames = csv.split(",");
        ClassLoader cl = AppConfiguration.class.getClassLoader();
        for (int i = 0; i < classNames.length; ++i) {
            classNames[i] = classNames[i].trim();
            if (classNames[i].length() <= 0) continue;
            log.debug("Attempting to load bundle class [{}]", (Object)classNames[i]);
            try {
                Class<?> klass = cl.loadClass(classNames[i]);
                if (!ConfiguredBundle.class.isAssignableFrom(klass)) {
                    throw new IllegalArgumentException("Class [" + classNames[i] + "] does not implement [" + ConfiguredBundle.class.getName() + "]");
                }
                ConfiguredBundle bundle = (ConfiguredBundle)klass.newInstance();
                bootstrap.addBundle(bundle);
                log.debug("Loaded bundle class [{}]", (Object)classNames[i]);
                continue;
            }
            catch (Throwable t) {
                throw new ConfigurationException("Error occurred while attempting to load bundle class [" + classNames[i] + "]", t);
            }
        }
    }

    static Pair<? extends Stoppable, Injector> loadAndInitializeModules(AppConfiguration conf, Environment env, ConfigurationProperties configurationProperties) {
        LinkedList<Module> modules = new LinkedList<Module>();
        List<ModuleConfiguration> moduleConfigurations = conf.getModules();
        if (moduleConfigurations == null) {
            log.info("No modules to load");
        } else {
            LinkedHashMap<ModuleConfiguration, Module> moduleInstances = Loaders.loadModules(moduleConfigurations, Module.class);
            Loaders.applyConfigurationsIfPossible(moduleInstances);
            log.debug("Loaded and configured modules [\n  - {}\n]", (Object)Joiner.on((String)"\n  - ").join(moduleInstances.values()));
            for (Module module : moduleInstances.values()) {
                modules.add(module);
            }
            moduleInstances.clear();
        }
        Pair<AppLifecycle, Injector> pair = Loaders.internalPrepareAndPreStart(conf, env, modules, configurationProperties);
        ((AppLifecycle)pair.getLeft()).manage(env.lifecycle());
        log.debug("Started modules");
        return pair;
    }

    static Pair<AppLifecycle, Injector> internalPrepareAndPreStart(AppConfiguration conf, Environment env, Iterable<? extends Module> modules, ConfigurationProperties configurationProperties) {
        LinkedList<Module> allModules = new LinkedList<Module>();
        for (Module module : modules) {
            Objects.requireNonNull(module, "List of modules cannot contain null elements");
            allModules.add(module);
        }
        AppLifecycle appLifecycle = new AppLifecycle();
        BootstrapModule bootstrapModule = new BootstrapModule(conf, env, appLifecycle, configurationProperties);
        allModules.add((Module)bootstrapModule);
        Injector injector = Guice.createInjector(allModules);
        Loaders.preStart(allModules, injector);
        return new ImmutablePair((Object)appLifecycle, (Object)injector);
    }

    static void preStart(@NonNull List<Module> modules, @NonNull Injector injector) {
        if (modules == null) {
            throw new IllegalArgumentException("modules is marked non-null but is null");
        }
        if (injector == null) {
            throw new IllegalArgumentException("injector is marked non-null but is null");
        }
        final HashSet instances = new HashSet();
        for (Binding binding : injector.getAllBindings().values()) {
            binding.acceptTargetVisitor((BindingTargetVisitor)new DefaultBindingTargetVisitor<Object, Void>(){

                public Void visit(InstanceBinding<?> instanceBinding) {
                    Object instance = instanceBinding.getInstance();
                    instances.add(instance);
                    return null;
                }
            });
        }
        for (Module module : modules) {
            if (instances.contains(module)) {
                log.trace("Module [{}] will not be explicitly injected", (Object)module);
                continue;
            }
            log.trace("Injecting module [{}]", (Object)module);
            injector.injectMembers((Object)module);
        }
    }

    public static Stoppable prepareAndPreStart(AppConfiguration conf, Environment env, Iterable<? extends Module> modules, ConfigurationProperties configurationProperties) {
        return (Stoppable)Loaders.internalPrepareAndPreStart(conf, env, modules, configurationProperties).getLeft();
    }

    public static <T> T instantiateClass(String className, Class<T> castTo, ClassLoader optionalClassLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class klass = Loaders.loadClass(className, optionalClassLoader);
        Object o = klass.newInstance();
        return castTo.cast(o);
    }

    public static Class loadClass(String className, ClassLoader optionalClassLoader) throws ClassNotFoundException {
        if (optionalClassLoader == null) {
            optionalClassLoader = Thread.currentThread().getContextClassLoader();
        }
        return optionalClassLoader.loadClass(className);
    }

    public static <MC extends ModuleConfiguration, M> LinkedHashMap<MC, M> loadModules(List<MC> moduleConfigurations, Class<M> moduleType) {
        log.debug("Attempting to load [{}] modules", (Object)moduleConfigurations.size());
        LinkedHashMap<ModuleConfiguration, M> moduleInstances = new LinkedHashMap<ModuleConfiguration, M>(moduleConfigurations.size());
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            String className = moduleConfiguration.getClassName();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = Loaders.class.getClassLoader();
            }
            try {
                String[] classPath = moduleConfiguration.getClassPath();
                if (classPath != null && classPath.length > 0) {
                    URL[] urls = new URL[classPath.length];
                    for (int i = 0; i < classPath.length; ++i) {
                        urls[i] = new URL(classPath[i]);
                    }
                    classLoader = new URLClassLoader(urls, classLoader);
                } else {
                    classPath = new String[]{};
                }
                log.debug("Attempting to load module class [{}]. Custom class path: {}", (Object)className, Arrays.asList(classPath));
                M instance = Loaders.instantiateClass(className, moduleType, classLoader);
                moduleInstances.put(moduleConfiguration, instance);
                log.debug("Loaded module class [{}]", (Object)className);
            }
            catch (Throwable t) {
                String msg = "Error occurred while attempting to load module class [" + className + "]";
                log.error(msg, t);
                throw new ConfigurationException(msg + ". Module loading has been halted", t);
            }
        }
        log.debug("Completed loading");
        return moduleInstances;
    }

    public static <MC extends ModuleConfiguration, M> void applyConfigurationsIfPossible(Map<MC, M> moduleInstances) {
        LinkedHashMap<ModuleConfiguration, Configurable> configurableTargets = new LinkedHashMap<ModuleConfiguration, Configurable>(moduleInstances.size());
        for (Map.Entry<MC, M> entry : moduleInstances.entrySet()) {
            ModuleConfiguration mc = (ModuleConfiguration)entry.getKey();
            M m = entry.getValue();
            String uri = mc.getUri();
            Object properties = mc.getProperties();
            if (m instanceof Configurable) {
                configurableTargets.put(mc, (Configurable)m);
                continue;
            }
            if (properties != null && (properties instanceof Collection && !((Collection)properties).isEmpty() || properties instanceof Map && !((Map)properties).isEmpty())) {
                log.warn("Module [{}] has properties [{}] specified but they could not be set as it is not an instance of [{}]", new Object[]{m.getClass().getName(), properties, Configurable.class.getName()});
            }
            if (uri == null) continue;
            log.warn("Module [{}] has a uri [{}] specified but it could not be set as it is not an instance of [{}]", new Object[]{m.getClass().getName(), uri, Configurable.class.getName()});
        }
        if (configurableTargets.size() > 0) {
            Loaders.applyConfigurations(configurableTargets);
        } else {
            log.warn("There were no [{}] instances", (Object)Configurable.class.getName());
        }
    }

    public static <MC extends ModuleConfiguration, M extends Configurable> void applyConfigurations(Map<MC, M> configsAndTargets) {
        log.debug("Attempting to configure [{}] modules", (Object)configsAndTargets.size());
        for (Map.Entry<MC, M> entry : configsAndTargets.entrySet()) {
            ModuleConfiguration mc = (ModuleConfiguration)entry.getKey();
            Configurable m = (Configurable)entry.getValue();
            try {
                String uri = mc.getUri();
                m.setUri(uri);
                Object properties = mc.getProperties();
                Object configuration = Reader.readFrom((TypeToken)m.getConfigurationType(), (Object)properties);
                m.setConfiguration(configuration);
            }
            catch (Throwable t) {
                throw new ConfigurationException("Error occurred while configuring module [" + m.getClass().getName() + "]", t);
            }
        }
        log.debug("Configuration completed");
    }
}

