/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework;

import com.appdynamics.common.framework.AppConfiguration;
import com.appdynamics.common.framework.AppInfo;
import com.appdynamics.common.framework.AppLifecycle;
import com.appdynamics.common.io.IoHelper;
import com.appdynamics.common.util.configuration.property.ConfigurationProperties;
import com.appdynamics.common.util.configuration.property.ConfigurationPropertiesHealthCheck;
import com.appdynamics.common.util.datetime.Ticker;
import com.appdynamics.common.util.feature.Features;
import com.appdynamics.common.util.feature.SimpleFeatures;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.appdynamics.common.util.lifecycle.LifecycleInjector;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import io.dropwizard.core.setup.Environment;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapModule.class);
    private final AppConfiguration conf;
    private final Environment env;
    private final AppLifecycle appLifecycle;
    private final AppInfo appInfo;
    private final ConsolidatedHealthCheck rootHealthCheck;
    private final ConfigurationProperties configurationProperties;
    private final Features features;
    private final Ticker ticker;

    BootstrapModule(AppConfiguration conf, Environment env, AppLifecycle appLifecycle, ConfigurationProperties configurationProperties) {
        this.conf = conf;
        this.env = env;
        this.appLifecycle = appLifecycle;
        this.configurationProperties = configurationProperties;
        this.ticker = new Ticker();
        log.info("Application configured with [{}]", (Object)configurationProperties);
        this.appInfo = this.findAppInfo();
        log.info("Build information [{}]", (Object)this.appInfo);
        this.features = new SimpleFeatures(this.appInfo.getVersion().toString());
        this.rootHealthCheck = new ConsolidatedHealthCheck(conf.getName(), env.healthChecks());
        if (configurationProperties != null) {
            this.rootHealthCheck.register(new ConfigurationPropertiesHealthCheck(configurationProperties));
        }
    }

    private AppInfo findAppInfo() {
        Path versionFile = this.getVersionFilePath();
        if (Files.exists(versionFile, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(versionFile, Charsets.UTF_8);
                return AppInfo.valueOf(lines);
            }
            catch (IOException e) {
                log.warn("Unable to get the build version from the manifest", (Throwable)e);
            }
        }
        return new AppInfo();
    }

    private Path getVersionFilePath() {
        Path appRoot;
        String libDir;
        String path = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            libDir = URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Object prefix = "";
        Path libDirPath = IoHelper.createOsSpecificPath((String)libDir);
        if (libDirPath != null && (appRoot = libDirPath.getParent()) != null) {
            prefix = appRoot.toString() + File.separator;
        }
        return Paths.get((String)prefix + "version.txt", new String[0]);
    }

    protected void configure() {
        this.bind(Environment.class).toInstance((Object)this.env);
        this.bind(AppConfiguration.class).toInstance((Object)this.conf);
        this.bind(AppInfo.class).toInstance((Object)this.appInfo);
        this.bind(Features.class).toInstance((Object)this.features);
        if (this.configurationProperties != null) {
            this.bind(ConfigurationProperties.class).toInstance((Object)this.configurationProperties);
        }
        this.bind(Ticker.class).toInstance((Object)this.ticker);
        this.appLifecycle.bind(this.binder());
        this.bind(LifecycleInjector.class).to(DefaultLifecycleInjector.class).in(Singleton.class);
        this.bind(ConsolidatedHealthCheck.class).toInstance((Object)this.rootHealthCheck);
        this.rootHealthCheck.register(new SimpleHealthCheck("Build information"){

            @Override
            public HealthCheck.Result check() {
                return HealthCheck.Result.healthy((String)BootstrapModule.this.appInfo.toString());
            }
        });
        this.bind(MetricRegistry.class).toInstance((Object)this.env.metrics());
    }

    @PreDestroy
    void onStop() {
        this.rootHealthCheck.discard();
    }

    static class DefaultLifecycleInjector
    implements LifecycleInjector {
        private Injector injector;

        @Inject
        DefaultLifecycleInjector(Injector injector) {
            this.injector = injector;
        }

        public <T> T inject(T annotatedTarget) {
            this.injector.injectMembers(annotatedTarget);
            return annotatedTarget;
        }

        @Generated
        void setInjector(Injector injector) {
            this.injector = injector;
        }
    }
}

