/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework;

import com.appdynamics.common.util.exception.PermanentException;
import com.appdynamics.common.util.lifecycle.Stoppable;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppLifecycle
implements Stoppable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppLifecycle.class);
    private volatile boolean lifecycleTrackingEnabled = true;
    private static final List<Class<? extends Annotation>> LIFECYCLE_ANNOTATIONS = ImmutableList.of(PreDestroy.class, PostConstruct.class);
    private final LoadingCache<Class<?>, Multimap<Class<? extends Annotation>, Method>> annotatedMethodsCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<Class<?>, Multimap<Class<? extends Annotation>, Method>>(){

        public Multimap<Class<? extends Annotation>, Method> load(Class<?> key) {
            HashMultimap map = HashMultimap.create((int)LIFECYCLE_ANNOTATIONS.size(), (int)1);
            for (Class<? extends Annotation> annotation : LIFECYCLE_ANNOTATIONS) {
                Set methods = ReflectionUtils.getAllMethods(key, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(annotation)});
                if (methods.size() <= 0) continue;
                map.putAll(annotation, (Iterable)methods);
            }
            return map;
        }
    });
    private final Deque<Object> preDestroyObjects = new LinkedList<Object>();
    private volatile boolean stopped = false;

    AppLifecycle() {
    }

    private synchronized void processInjectee(Object injectee) {
        if (this.stopped) {
            throw new PermanentException("Lifecycle manager is stopping. Cannot create any more objects.");
        }
        if (!this.lifecycleTrackingEnabled) {
            return;
        }
        log.trace("Injecting object {}", injectee);
        Multimap lifecycleMethods = (Multimap)this.annotatedMethodsCache.getUnchecked(injectee.getClass());
        this.callAnnotatedMethods((Multimap<Class<? extends Annotation>, Method>)lifecycleMethods, PostConstruct.class, injectee);
        Collection stopMethods = lifecycleMethods.get(PreDestroy.class);
        if (stopMethods.size() > 0) {
            this.preDestroyObjects.addFirst(injectee);
        }
    }

    private void processTypeEncounter(TypeLiteral<?> type, TypeEncounter<?> encounter) {
        try {
            this.annotatedMethodsCache.getUnchecked((Object)type.getRawType());
        }
        catch (UncheckedExecutionException e) {
            encounter.addError(e.getCause());
        }
        encounter.register((InjectionListener)new InjectionListener<Object>(){

            public void afterInjection(Object injectee) {
                AppLifecycle.this.processInjectee(injectee);
            }
        });
    }

    public synchronized void stop() {
        for (Object obj : this.preDestroyObjects) {
            Multimap lifecycleMethods = (Multimap)this.annotatedMethodsCache.getUnchecked(obj.getClass());
            this.callAnnotatedMethods((Multimap<Class<? extends Annotation>, Method>)lifecycleMethods, PreDestroy.class, obj);
        }
        this.preDestroyObjects.clear();
        this.stopped = true;
    }

    private void callAnnotatedMethods(Multimap<Class<? extends Annotation>, Method> lifecycleMethods, Class<? extends Annotation> annotation, Object target) {
        Collection methods = lifecycleMethods.get(annotation);
        HashSet<Method> calledMethods = new HashSet<Method>();
        for (Method method : methods) {
            try {
                Method targetMethod = this.findTargetMethod(target.getClass(), method.getName(), method.getParameterTypes());
                if (!calledMethods.contains(targetMethod)) {
                    targetMethod.setAccessible(true);
                    targetMethod.invoke(target, new Object[0]);
                    calledMethods.add(targetMethod);
                    continue;
                }
                log.debug("Did not call [{}] since it has already been called.", (Object)targetMethod.toGenericString());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String msg = "Could not invoke " + annotation.getSimpleName() + "-annotated method on " + String.valueOf(target);
                log.error(msg, (Throwable)e);
                throw new PermanentException(msg, (Throwable)e);
            }
        }
    }

    private Method findTargetMethod(Class<?> cls, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return cls.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> parent = cls.getSuperclass();
            if (parent.equals(Object.class)) {
                throw e;
            }
            return this.findTargetMethod(parent, name, parameterTypes);
        }
    }

    void bind(Binder binder) {
        binder.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                AppLifecycle.this.processTypeEncounter(type, encounter);
            }
        });
        binder.bindInterceptor(Matchers.subclassesOf(Provider.class), (Matcher)new AbstractMatcher<Method>(){

            public boolean matches(Method method) {
                return "get".equals(method.getName()) && method.getParameterTypes().length == 0 && !method.isSynthetic() && !method.isBridge();
            }
        }, new MethodInterceptor[]{new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                Object obj = invocation.proceed();
                AppLifecycle.this.processInjectee(obj);
                return obj;
            }
        }});
    }

    void manage(LifecycleEnvironment lifecycle) {
        lifecycle.manage(new Managed(){

            public void start() {
            }

            public void stop() {
                try {
                    AppLifecycle.this.stop();
                }
                catch (Throwable e) {
                    log.error("Error occurred during shut down", e);
                }
            }
        });
    }

    @Generated
    void setLifecycleTrackingEnabled(boolean lifecycleTrackingEnabled) {
        this.lifecycleTrackingEnabled = lifecycleTrackingEnabled;
    }
}

