/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework;

import com.appdynamics.common.framework.version.CalendarVersion;
import com.appdynamics.common.util.configuration.Reader;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import lombok.Generated;

public class AppInfo {
    private static final String BUILD_NOT_FOUND = "Build not found";
    private static final String ORIGINAL_STRING = "originalString";
    private static final Joiner ORIGINAL_STRING_JOINER = Joiner.on((String)", ");
    private final String buildName;
    private final String buildHash;
    private final String buildTimestamp;
    private final String buildNumber;
    private final String jobName;
    private final CalendarVersion version;
    @JsonProperty(value="originalString")
    private final String originalString;

    public AppInfo() {
        this.buildName = BUILD_NOT_FOUND;
        this.buildHash = BUILD_NOT_FOUND;
        this.buildTimestamp = BUILD_NOT_FOUND;
        this.buildNumber = BUILD_NOT_FOUND;
        this.jobName = BUILD_NOT_FOUND;
        this.version = new CalendarVersion(String.format("%s.%s.%s-%s", Collections.nCopies(4, 1).toArray()));
        this.originalString = BUILD_NOT_FOUND;
    }

    public static AppInfo valueOf(Collection<String> versionLines) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String line : versionLines) {
            String[] splitLine = line.split("=");
            if (splitLine.length != 2) continue;
            propertyMap.put(splitLine[0], splitLine[1]);
        }
        propertyMap.put(ORIGINAL_STRING, ORIGINAL_STRING_JOINER.join(versionLines));
        return (AppInfo)Reader.DEFAULT_JSON_MAPPER.convertValue(propertyMap, AppInfo.class);
    }

    public String toString() {
        return this.originalString;
    }

    @ConstructorProperties(value={"buildName", "buildHash", "buildTimestamp", "buildNumber", "jobName", "version", "originalString"})
    @Generated
    public AppInfo(String buildName, String buildHash, String buildTimestamp, String buildNumber, String jobName, CalendarVersion version, String originalString) {
        this.buildName = buildName;
        this.buildHash = buildHash;
        this.buildTimestamp = buildTimestamp;
        this.buildNumber = buildNumber;
        this.jobName = jobName;
        this.version = version;
        this.originalString = originalString;
    }

    @Generated
    public String getBuildName() {
        return this.buildName;
    }

    @Generated
    public String getBuildHash() {
        return this.buildHash;
    }

    @Generated
    public String getBuildTimestamp() {
        return this.buildTimestamp;
    }

    @Generated
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public CalendarVersion getVersion() {
        return this.version;
    }
}

