/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.YamlConfigurationFactory;
import jakarta.validation.Validator;
import java.io.IOException;
import java.util.Iterator;

public class AppConfigurationFactory<T>
extends YamlConfigurationFactory<T> {
    private final String connectorTypeToRemove;

    public AppConfigurationFactory(Class<T> klass, Validator validator, ObjectMapper objectMapper, String propertyPrefix, boolean isHttpsEnabled) {
        super(klass, validator, objectMapper, propertyPrefix);
        this.connectorTypeToRemove = isHttpsEnabled ? "http" : "https";
    }

    protected T build(JsonNode node, String path) throws IOException, ConfigurationException {
        JsonNode updatedJsonNode = this.removeUnusedConnector(node);
        return (T)super.build(updatedJsonNode, path);
    }

    private JsonNode removeUnusedConnector(JsonNode jsonNode) {
        JsonNode connectorsNode = jsonNode.findPath("applicationConnectors");
        if (connectorsNode.isArray()) {
            ArrayNode connectors = (ArrayNode)connectorsNode;
            Iterator connectorsIterator = connectors.iterator();
            while (connectorsIterator.hasNext()) {
                JsonNode connector = (JsonNode)connectorsIterator.next();
                String connectorType = connector.path("type").asText();
                if (!this.connectorTypeToRemove.equalsIgnoreCase(connectorType)) continue;
                connectorsIterator.remove();
                break;
            }
        }
        return jsonNode;
    }
}

