/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework;

import com.appdynamics.common.framework.AppConfiguration;
import com.appdynamics.common.framework.AppConfigurationFactoryFactory;
import com.appdynamics.common.framework.Loaders;
import com.appdynamics.common.io.file.FileSource;
import com.appdynamics.common.util.configuration.property.ConfigurationProperties;
import com.appdynamics.common.util.configuration.property.ConfigurationPropertiesBuilder;
import com.appdynamics.common.util.configuration.property.ConfigurationResolver;
import com.appdynamics.common.util.lifecycle.Stoppable;
import com.appdynamics.common.util.var.Variables;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import io.dropwizard.core.Application;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApp<C extends AppConfiguration>
extends Application<C> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractApp.class);
    public static final String MSG_TEMPLATE_STARTUP = "\nConfiguration options/usage:\n  -y or --yml\n     YML file to use (required).\n\n     Variables in the YML file will be substituted using mappings provided in the\n     system properties, environment variables or the accompanying properties file\n     (if provided) and in that order.\n\n  -p or --properties\n     Properties file (optional)\n";
    protected ConfigurationProperties configurationProperties;
    private final boolean embeddedMode;
    private LazyCommand command;

    protected AbstractApp() {
        this(false);
    }

    protected AbstractApp(boolean embeddedMode) {
        this.embeddedMode = embeddedMode;
    }

    public boolean isEmbeddedMode() {
        return this.embeddedMode;
    }

    public static Pair<FileSource, Optional<String>> validate(String[] args) {
        if (args == null || args.length == 0 || args.length % 2 != 0) {
            throw new IllegalArgumentException("Wrong number of arguments " + Arrays.toString(args) + ".\nConfiguration options/usage:\n  -y or --yml\n     YML file to use (required).\n\n     Variables in the YML file will be substituted using mappings provided in the\n     system properties, environment variables or the accompanying properties file\n     (if provided) and in that order.\n\n  -p or --properties\n     Properties file (optional)\n");
        }
        FileSource yml = null;
        String props = null;
        block13: for (int i = 0; i < args.length; i += 2) {
            String flag = args[i];
            String value = args[i + 1];
            switch (flag) {
                case "-y": 
                case "--yml": {
                    yml = new FileSource(value, false);
                    continue block13;
                }
                case "-yr": 
                case "--yml-resource": {
                    yml = new FileSource(value, true);
                    continue block13;
                }
                case "-p": 
                case "--properties": {
                    props = value;
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported argument: " + flag + " " + value + MSG_TEMPLATE_STARTUP);
                }
            }
        }
        return new ImmutablePair(yml, (Object)Optional.fromNullable(props));
    }

    public final void runUsingTemplate(String[] args) throws Exception {
        this.runUsingTemplate(args, null);
    }

    public final void runUsingTemplate(String[] args, @Nullable List<ConfigurationResolver> optConfigurationResolvers) throws Exception {
        Pair<FileSource, Optional<String>> ymlAndTemplatePropsFile = AbstractApp.validate(args);
        FileSource yml = (FileSource)ymlAndTemplatePropsFile.getLeft();
        String props = (String)((Optional)ymlAndTemplatePropsFile.getRight()).orNull();
        this.runUsingTemplate(yml, props, optConfigurationResolvers);
    }

    public final void runUsingTemplate(FileSource serviceConfigurationTemplate) throws Exception {
        this.runUsingTemplate(serviceConfigurationTemplate, null);
    }

    public final void runUsingTemplate(FileSource serviceConfigurationTemplate, @Nullable String templateVariablesPropertiesFile) throws Exception {
        this.runUsingTemplate(serviceConfigurationTemplate, templateVariablesPropertiesFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runUsingTemplate(FileSource serviceConfigurationTemplate, @Nullable String templateVariablesPropertiesFile, @Nullable List<ConfigurationResolver> optConfigurationResolvers) throws Exception {
        File tmpFile;
        this.configurationProperties = AbstractApp.initConfigurationProperties(templateVariablesPropertiesFile, optConfigurationResolvers);
        if (!serviceConfigurationTemplate.isResource()) {
            tmpFile = Variables.resolveVariables((FileSource)serviceConfigurationTemplate, (ConfigurationProperties)this.configurationProperties);
        } else {
            try (InputStream is = AbstractApp.class.getResourceAsStream("/" + serviceConfigurationTemplate.getSource());){
                tmpFile = Variables.resolveVariables((String)serviceConfigurationTemplate.getSource(), (InputStream)is, (ConfigurationProperties)this.configurationProperties);
            }
        }
        try {
            this.runUsingFile(tmpFile.getAbsolutePath());
        }
        finally {
            if (!tmpFile.delete()) {
                log.debug("The temporary configuration file [{}] could not be deleted", (Object)tmpFile.getAbsolutePath());
            }
        }
    }

    public final void runUsingFile(String serviceConfigurationFile) {
        this.callRunServer(serviceConfigurationFile);
    }

    private void callRunServer(String serviceConfigurationFile) {
        try {
            this.command = this.makeCommand();
            this.run(new String[]{this.command.name, serviceConfigurationFile});
        }
        catch (Throwable t) {
            this.handleSevereError(this.getName(), t);
        }
    }

    protected abstract LazyCommand makeCommand();

    public final void initialize(Bootstrap<C> bootstrap) {
        try {
            if (this.command.optCommand.isPresent()) {
                bootstrap.addCommand((Command)this.command.optCommand.get());
            }
            boolean isHttpsEnabled = this.configurationProperties != null && this.configurationProperties.getBoolean("ad.dw.https.enabled", false);
            bootstrap.setConfigurationFactoryFactory(new AppConfigurationFactoryFactory(isHttpsEnabled));
            Loaders.loadAndAddBundles(bootstrap);
        }
        catch (Throwable t) {
            this.handleSevereError(this.getName(), t);
        }
    }

    public final void run(C conf, Environment env) {
        try {
            this.beforeModuleLoading(conf, env);
            Pair<? extends Stoppable, Injector> pair = Loaders.loadAndInitializeModules(conf, env, this.configurationProperties);
            this.afterModuleLoading(conf, env, (Stoppable)pair.getLeft(), (Injector)pair.getRight());
        }
        catch (Throwable t) {
            this.handleSevereError(((AppConfiguration)((Object)conf)).getName(), t);
        }
    }

    protected void beforeModuleLoading(C conf, Environment env) {
    }

    protected void afterModuleLoading(C conf, Environment env, Stoppable appLifecycle, Injector injector) {
    }

    private void handleSevereError(String appName, Throwable t) {
        String msg = "Severe error occurred while starting application [" + appName + "]. Shutdown procedure will commence soon\n" + Throwables.getStackTraceAsString((Throwable)t) + (this.embeddedMode ? "" : Strings.repeat((String)" ", (int)4096));
        log.error(msg);
        if (!this.embeddedMode) {
            String name = appName + "-error-shutdown-thread";
            new Thread(name){

                @Override
                public void run() {
                    AbstractApp.quit();
                }
            }.start();
        } else {
            log.error("The application [" + appName + "] could not be shutdown cleanly. It is recommended that the JVM be restarted after the problem is addressed" + Strings.repeat((String)" ", (int)4096));
            Throwables.propagate((Throwable)t);
        }
    }

    private static ConfigurationProperties initConfigurationProperties(@Nullable String templateVariablesPropertiesFile, @Nullable List<ConfigurationResolver> optConfigurationResolvers) {
        File f;
        ConfigurationPropertiesBuilder configPropertiesBuilder = new ConfigurationPropertiesBuilder();
        if (optConfigurationResolvers != null && optConfigurationResolvers.size() != 0) {
            for (ConfigurationResolver configurationResolver : optConfigurationResolvers) {
                configPropertiesBuilder.addConfigurationResolver(configurationResolver);
            }
        }
        configPropertiesBuilder.addSystemPropertiesResolver().addEnvironmentPropertiesResolver().addSystemVariableResolver();
        if (templateVariablesPropertiesFile != null && (f = new File(templateVariablesPropertiesFile)).exists() && f.isFile()) {
            String filePath = f.getAbsolutePath();
            System.setProperty("ad.prop.file.path", filePath);
            configPropertiesBuilder.addPropertiesFileResolver(filePath);
        }
        return configPropertiesBuilder.addFileIncludeResolver().addCalendarResolver().applySecureCredentialResolver().build();
    }

    private static void quit() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(-1);
    }

    public static class LazyCommand {
        final String name;
        final Optional<? extends Command> optCommand;

        public LazyCommand(String name, Optional<? extends Command> optCommand) {
            this.name = name;
            this.optCommand = optCommand;
        }
    }
}

