/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.util;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.configuration.Reader;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import lombok.Generated;
import org.apache.commons.io.Charsets;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionHandlerFilter;
import org.kohsuke.args4j.spi.OptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Args4jHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Args4jHelper.class);

    private Args4jHelper() {
    }

    public static String extractUsage(Object args4jAnnotatedObj) {
        String string;
        Preconditions.checkNotNull((Object)(args4jAnnotatedObj != null ? 1 : 0), (Object)"Destination object cannot be null");
        CustomCmdLineParser parser = new CustomCmdLineParser(args4jAnnotatedObj, 100);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            parser.printUsage(baos);
            string = new String(baos.toByteArray(), Charsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }
        baos.close();
        return string;
    }

    public static void transform(Arguments from, Object args4jAnnotatedObj) {
        Args4jHelper.transformAnnotatedObject(from, args4jAnnotatedObj, 1);
    }

    public static void transformAll(Arguments from, Object args4jAnnotatedObj) {
        Args4jHelper.transformAnnotatedObject(from, args4jAnnotatedObj, 0);
    }

    private static void transformAnnotatedObject(Arguments from, Object args4jAnnotatedObj, int startIndex) {
        Preconditions.checkNotNull((Object)(from != null ? 1 : 0), (Object)"Arguments cannot be null");
        String[] items = from.getItems();
        Preconditions.checkNotNull((Object)(items != null ? 1 : 0), (Object)"Arguments.items cannot be null");
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0, (String)"Start index should not be negative Found [%d]", (int)startIndex);
        Preconditions.checkArgument((items.length >= 1 ? 1 : 0) != 0, (String)"At least 1 or more Arguments.items were expected. Found [%s]", (int)items.length);
        Preconditions.checkNotNull((Object)(args4jAnnotatedObj != null ? 1 : 0), (Object)"Destination object cannot be null");
        items = items.length == 1 ? new String[]{} : Arrays.copyOfRange(items, startIndex, items.length);
        CmdLineParser parser = new CmdLineParser(args4jAnnotatedObj);
        try {
            parser.parseArgument(items);
            Reader.validate((Object)args4jAnnotatedObj);
        }
        catch (ConfigurationException | CmdLineException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public static class CustomCmdLineParser
    extends CmdLineParser {
        private final int wrapAtLength;

        public CustomCmdLineParser(Object args4jAnnotatedObj, int wrapAtLength) {
            super(args4jAnnotatedObj);
            this.setUsageWidth(wrapAtLength);
            this.wrapAtLength = wrapAtLength;
        }

        protected void printOption(PrintWriter out, OptionHandler handler, int len, ResourceBundle rb, OptionHandlerFilter filter) {
            if (!filter.select(handler)) {
                return;
            }
            out.println();
            out.print("\t");
            out.print(handler.getNameAndMeta(rb));
            out.println();
            if (handler.option.required()) {
                out.print("\t(Required. ");
            } else {
                out.print("\t(Optional. ");
            }
            String usage = Strings.nullToEmpty((String)handler.option.usage());
            usage = rb == null ? usage : rb.getString(usage);
            int i = 0;
            for (String usageSubString : CustomCmdLineParser.wrap(usage, this.wrapAtLength)) {
                if (i > 0) {
                    out.print("\n\t");
                }
                out.print(usageSubString);
                ++i;
            }
            out.println(")");
        }

        private static List<String> wrap(String givenString, int wrapAtLength) {
            LinkedList<String> wrappedStrings = new LinkedList<String>();
            String workString = givenString;
            while (workString.length() > 0) {
                int lastSpaceInPartialString;
                int lengthToCut = Math.min(workString.length(), wrapAtLength);
                String wrappedPartialString = workString.substring(0, lengthToCut);
                if (wrappedPartialString.length() < workString.length() && workString.charAt(lengthToCut - 1) != ' ' && (lastSpaceInPartialString = wrappedPartialString.lastIndexOf(32)) > -1) {
                    lengthToCut = Math.min(lastSpaceInPartialString, wrappedPartialString.length());
                    wrappedPartialString = workString.substring(0, lengthToCut);
                }
                wrappedStrings.add(wrappedPartialString);
                if (workString.length() <= lengthToCut) break;
                workString = workString.charAt(lengthToCut) == ' ' ? workString.substring(lengthToCut + 1) : workString.substring(lengthToCut);
            }
            return wrappedStrings;
        }
    }

    public static abstract class MetaVars {
        public static final String PATH = "TYPE_PATH";
        public static final String URL = "TYPE_URL";
        public static final String NUMBER = "TYPE_NUMBER";
        public static final String BOOLEAN = "TYPE_BOOLEAN";
        public static final String STRING = "TYPE_STRING";
        public static final String KEY_VALUE = "TYPE_KEY_VALUE";
        public static final String FILE_NAME = "TYPE_FILE_NAME";
        public static final String DRY_RUN_USAGE = "Prints the command line arguments that would've been used to start the program. A marker text should be provided that gets printed just before the command line. This is useful if the command line has to be extracted (using Grep/Awk) to perform other actions";
        public static final String MULTI_VALUE_USAGE = "Multiple values separated by space";

        private MetaVars() {
        }
    }
}

