/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.standalone;

import com.appdynamics.common.executor.standalone.ProxyMainLogHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class ProxyMain {
    public static final String PROXY_MAIN_PARAMETER_PREFIX = "-PM";
    public static final String FILE_MANIFEST = "META-INF/MANIFEST.MF";
    public static final String ATTRIBUTE_ACTUAL_MAIN_CLASS = "Actual-Main-Class";
    public static final String ATTRIBUTE_ACTUAL_CLASS_PATH = "Actual-Class-Path";
    public static final String DEFAULT_CLASS_PATH = ".";
    public static final String METHOD_NAME = "main";
    public static final String FILE_EXTENSION_JAR = ".jar";
    public static final String FILE_EXTENSION_ZIP = ".zip";

    private ProxyMain() {
    }

    public static void main(String[] args) {
        try {
            if (args == null) {
                throw new NullPointerException("Arguments cannot be null");
            }
            LinkedList<String> filteredArgs = new LinkedList<String>();
            for (String arg : args) {
                if (arg.startsWith(PROXY_MAIN_PARAMETER_PREFIX)) {
                    Properties proxyMainProperties = new Properties();
                    String proxyProperty = arg.substring(PROXY_MAIN_PARAMETER_PREFIX.length());
                    proxyMainProperties.load(new StringReader(proxyProperty));
                    String isVerboseString = proxyMainProperties.getProperty("log.level");
                    if (isVerboseString == null || !isVerboseString.trim().equals("DEBUG")) continue;
                    ProxyMainLogHelper.changeLogLevelVerbosity(true);
                    continue;
                }
                filteredArgs.add(arg);
            }
            String[] newArgs = filteredArgs.toArray(new String[filteredArgs.size()]);
            ProxyMain.callActualMain(newArgs);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(-1);
        }
    }

    static void callActualMain(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> actualMainClass;
        String actualMainClassName = null;
        String classPath = DEFAULT_CLASS_PATH;
        ClassLoader topClassLoader = ProxyMain.class.getClassLoader();
        Enumeration<URL> manifestUrls = topClassLoader.getResources(FILE_MANIFEST);
        while (manifestUrls.hasMoreElements()) {
            URL url = manifestUrls.nextElement();
            InputStream is = url.openStream();
            try {
                Manifest manifest = new Manifest(is);
                Attributes attributes = manifest.getMainAttributes();
                actualMainClassName = attributes.getValue(ATTRIBUTE_ACTUAL_MAIN_CLASS);
                if (actualMainClassName == null) continue;
                classPath = attributes.getValue(ATTRIBUTE_ACTUAL_CLASS_PATH);
                break;
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        ProxyMain.logVerbose("The class name that will be called is [" + actualMainClassName + "] using the classpath [" + classPath + "]");
        if (actualMainClassName == null) {
            throw new IllegalArgumentException("The manifest does not contain the attribute [Actual-Main-Class]");
        }
        final String cp = classPath;
        final ClassLoader topCL = topClassLoader;
        URLClassLoader urlClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                URL[] jarUrls = ProxyMain.findJarUrls(cp);
                URLClassLoader urlClassLoader = new URLClassLoader(jarUrls, topCL);
                Thread.currentThread().setContextClassLoader(urlClassLoader);
                return urlClassLoader;
            }
        });
        ProxyMain.logVerbose("Calling [" + actualMainClassName + "] with arguments " + String.valueOf(Arrays.asList(args)));
        try {
            actualMainClass = Class.forName(actualMainClassName, true, urlClassLoader);
        }
        catch (UnsupportedClassVersionError error) {
            ProxyMain.log("Incompatible Java version detected while running the program. A newer version of Java may be required\n");
            throw error;
        }
        Method actualMainMethod = actualMainClass.getMethod(METHOD_NAME, String[].class);
        actualMainMethod.invoke(null, new Object[]{args});
    }

    static URL[] findJarUrls(String classPath) {
        Path codeSourcePath;
        CodeSource codeSource = ProxyMain.class.getProtectionDomain().getCodeSource();
        ProxyMain.logVerbose("This JAR is [" + String.valueOf(codeSource.getLocation()) + "]");
        try {
            String codeSourceUrl = URLDecoder.decode(codeSource.getLocation().getPath(), StandardCharsets.UTF_8.name());
            codeSourcePath = new File(codeSourceUrl).toPath();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("The directory that is supposed to contain the libraries is invalid [" + codeSource.getLocation().getPath() + "]");
        }
        ProxyMain.logVerbose("This JAR is located at [" + String.valueOf(codeSourcePath) + "]");
        Path codeSourceParentPath = codeSourcePath.getParent();
        if (codeSourceParentPath == null) {
            throw new IllegalArgumentException("The directory containing the code source path was null.");
        }
        codeSourceParentPath = codeSourceParentPath.toAbsolutePath();
        Path resolvedClassPath = codeSourceParentPath.resolve(new File(classPath).toPath());
        ProxyMain.logVerbose("The path that will be used to load classes is [" + String.valueOf(resolvedClassPath) + "]");
        Path actualClassPath = resolvedClassPath.toAbsolutePath();
        File actualClassDir = actualClassPath.toFile();
        if (!actualClassDir.exists() || !actualClassDir.isDirectory()) {
            throw new IllegalArgumentException("The directory that is supposed to contain the libraries is invalid [" + actualClassDir.getAbsolutePath() + "]");
        }
        try {
            final ArrayList jarPaths = new ArrayList();
            SimpleFileVisitor<Path> matcherVisitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes baf) {
                    String string = file.toString();
                    if (string.endsWith(ProxyMain.FILE_EXTENSION_JAR) || string.endsWith(ProxyMain.FILE_EXTENSION_ZIP)) {
                        ProxyMain.logVerbose("Adding [" + string + "] to the classpath");
                        jarPaths.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            Files.walkFileTree(actualClassPath, (FileVisitor<? super Path>)matcherVisitor);
            URL[] jarUrls = new URL[jarPaths.size()];
            int i = 0;
            for (Path jarPath : jarPaths) {
                Path p = jarPath.toRealPath(new LinkOption[0]);
                jarUrls[i++] = new URL(p.toUri().toString());
                ProxyMain.logVerbose("URL [" + String.valueOf(jarUrls[i - 1]) + "]");
            }
            return jarUrls;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The operation could not be performed because the library classpath is invalid or the expected directory structure is incorrect", e);
        }
    }

    static void log(String message) {
        System.out.println(message);
    }

    static void logVerbose(String message) {
        if (ProxyMainLogHelper.isLogLevelVerbose()) {
            System.out.println(message);
        }
    }
}

