/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command.windows;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.util.Args4jHelper;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.kohsuke.args4j.Option;

public class AppInstallServiceOptions
implements Options {
    public static final String OPTION_NAME = "service-install";

    @Override
    public String getName() {
        return OPTION_NAME;
    }

    @Override
    public String getUsage() {
        return "service-install " + Args4jHelper.extractUsage(new ParsedArguments());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean canExecute(Arguments arguments) {
        String[] items = arguments.getItems();
        return items != null && items.length > 0 && items[0].equals(OPTION_NAME);
    }

    public ParsedArguments parse(Arguments arguments) {
        ParsedArguments parsedArguments = new ParsedArguments();
        Args4jHelper.transform(arguments, parsedArguments);
        return parsedArguments;
    }

    public static class ParsedArguments {
        @Option(required=true, name="-p", aliases={"--properties"}, usage="Path to the properties file", metaVar="TYPE_PATH")
        @NotNull
        String pathToProperties;
        @Option(required=false, name="--auto-start", usage="Set the service to auto, default is manual", metaVar="TYPE_BOOLEAN")
        @NotNull
        boolean autoStart = false;
        @Option(required=false, name="--log-verbose", usage="Set log level to DEBUG, default is INFO", metaVar="TYPE_BOOLEAN")
        @NotNull
        boolean verboseLog = false;
        @Option(required=false, name="-dr", aliases={"--dry-run"}, usage="Prints the command line arguments that would've been used to start the program. A marker text should be provided that gets printed just before the command line. This is useful if the command line has to be extracted (using Grep/Awk) to perform other actions", metaVar="TYPE_STRING", hidden=true)
        String dryRun;

        @Generated
        public ParsedArguments() {
        }

        @Generated
        public String getPathToProperties() {
            return this.pathToProperties;
        }

        @Generated
        public boolean isAutoStart() {
            return this.autoStart;
        }

        @Generated
        public boolean isVerboseLog() {
            return this.verboseLog;
        }

        @Generated
        public String getDryRun() {
            return this.dryRun;
        }

        @Generated
        public void setPathToProperties(String pathToProperties) {
            this.pathToProperties = pathToProperties;
        }

        @Generated
        public void setAutoStart(boolean autoStart) {
            this.autoStart = autoStart;
        }

        @Generated
        public void setVerboseLog(boolean verboseLog) {
            this.verboseLog = verboseLog;
        }

        @Generated
        public void setDryRun(String dryRun) {
            this.dryRun = dryRun;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParsedArguments)) {
                return false;
            }
            ParsedArguments other = (ParsedArguments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAutoStart() != other.isAutoStart()) {
                return false;
            }
            if (this.isVerboseLog() != other.isVerboseLog()) {
                return false;
            }
            String this$pathToProperties = this.getPathToProperties();
            String other$pathToProperties = other.getPathToProperties();
            if (this$pathToProperties == null ? other$pathToProperties != null : !this$pathToProperties.equals(other$pathToProperties)) {
                return false;
            }
            String this$dryRun = this.getDryRun();
            String other$dryRun = other.getDryRun();
            return !(this$dryRun == null ? other$dryRun != null : !this$dryRun.equals(other$dryRun));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParsedArguments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAutoStart() ? 79 : 97);
            result = result * 59 + (this.isVerboseLog() ? 79 : 97);
            String $pathToProperties = this.getPathToProperties();
            result = result * 59 + ($pathToProperties == null ? 43 : $pathToProperties.hashCode());
            String $dryRun = this.getDryRun();
            result = result * 59 + ($dryRun == null ? 43 : $dryRun.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AppInstallServiceOptions.ParsedArguments(pathToProperties=" + this.getPathToProperties() + ", autoStart=" + this.isAutoStart() + ", verboseLog=" + this.isVerboseLog() + ", dryRun=" + this.getDryRun() + ")";
        }
    }
}

