/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command.windows;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Command;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.command.CommandHelper;
import com.appdynamics.common.executor.command.SubProcessManager;
import com.appdynamics.common.executor.command.windows.AppInstallServiceOptions;
import com.appdynamics.common.executor.command.windows.AppServiceConstants;
import com.appdynamics.common.executor.command.windows.WindowsCommandHelper;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppInstallServiceCommand
implements Command {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppInstallServiceCommand.class);
    private static final AppInstallServiceOptions INSTALL_OPTIONS = new AppInstallServiceOptions();
    private final String thinJarName;
    private final String mainClassName;
    protected final List<String> commandLineArguments;

    public AppInstallServiceCommand(String thinJarName, String mainClassName) {
        this.thinJarName = thinJarName;
        this.mainClassName = mainClassName;
        this.commandLineArguments = new ArrayList<String>();
    }

    @Override
    public Options getOptions() {
        return INSTALL_OPTIONS;
    }

    @Override
    public void execute(Arguments arguments) {
        AppInstallServiceOptions.ParsedArguments parsedArguments = INSTALL_OPTIONS.parse(arguments);
        try {
            Path pathToProperties = Paths.get(parsedArguments.getPathToProperties(), new String[0]);
            Path absolutePathToProperties = pathToProperties.toAbsolutePath();
            CommandHelper.checkFileExists(absolutePathToProperties);
            Properties analyticsProperties = CommandHelper.readProperties(pathToProperties);
            Path pathToConfDir = CommandHelper.getPathToConfDir();
            Path pathToHomeDir = CommandHelper.getPathToHomeDir();
            Path pathToApacheDaemons = CommandHelper.getPathToApacheDaemonsExecutor();
            Path pathToExecutorJar = pathToHomeDir.resolve(AppServiceConstants.JAR_EXECUTOR_RELATIVE_TO_HOME_PATH + this.thinJarName);
            Path pathToVmOptions = CommandHelper.getPathToVmOptions(analyticsProperties, pathToConfDir);
            CommandHelper.checkFileExists(pathToVmOptions);
            CommandHelper.checkFileExists(pathToApacheDaemons);
            CommandHelper.checkFileExists(pathToExecutorJar);
            this.commandLineArguments.add(pathToApacheDaemons.toAbsolutePath().toString());
            String processName = CommandHelper.readProperty(analyticsProperties, "ad.process.name");
            String serviceName = WindowsCommandHelper.generateServiceName(processName);
            log.debug("Service name [{}]", (Object)serviceName);
            this.addInstallArguments(pathToApacheDaemons, serviceName);
            boolean isVerboseLog = parsedArguments.isVerboseLog();
            this.addLogArguments(pathToHomeDir, processName, analyticsProperties, isVerboseLog);
            boolean jreBundled = this.addJreBundled();
            this.commandLineArguments.add("--Classpath=" + (String)(jreBundled ? "\"" + pathToExecutorJar.toString() + "\"" : pathToExecutorJar.toString()));
            String javaMode = jreBundled ? "java" : "jvm";
            this.addStartArguments(absolutePathToProperties.toString(), javaMode, isVerboseLog, parsedArguments.isAutoStart());
            this.addStopArguments(processName, javaMode);
            this.commandLineArguments.add(this.addVmOptions(analyticsProperties, pathToVmOptions, pathToHomeDir));
            this.commandLineArguments.add("--Environment=APPLICATION_HOME=" + pathToHomeDir.toString());
            this.commandLineArguments.add("--Environment=JAVA_HOME=" + System.getenv("JAVA_HOME"));
            this.commandLineArguments.add("--Description=Located at: " + pathToHomeDir.toString());
            String finalCommandLine = Joiner.on((String)" ").join(this.commandLineArguments);
            if (StringUtils.isEmpty((CharSequence)parsedArguments.getDryRun())) {
                this.executeCommand(this.commandLineArguments);
            } else {
                log.info("Program can be run using\n\n" + parsedArguments.getDryRun() + "{}", (Object)finalCommandLine);
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    void executeCommand(List<String> commandLineArguments) {
        SubProcessManager.execute(commandLineArguments);
    }

    private void addInstallArguments(Path pathToApacheDaemonsExecutor, String serviceName) {
        this.commandLineArguments.add("//IS//" + serviceName);
        this.commandLineArguments.add("--Install=" + pathToApacheDaemonsExecutor.toAbsolutePath().toString());
    }

    private void addLogArguments(Path pathToHomeDir, String processName, Properties p, boolean isVerboseLog) throws IOException {
        String logLevel = isVerboseLog ? "DEBUG" : CommandHelper.readProperty(p, "ad.dw.log.level");
        String logValue = CommandHelper.readLogPath(p);
        Path logPath = pathToHomeDir.resolve(logValue);
        String serviceSuffix = "-service";
        DateTime now = new DateTime();
        Path stdoutPath = logPath.resolve(processName + serviceSuffix + "." + now.getYear() + "-" + String.format("%02d", now.getMonthOfYear()) + "-" + String.format("%02d", now.getDayOfMonth()) + ".log");
        log.debug("Log folder [{}]", (Object)logPath);
        this.commandLineArguments.add("--LogLevel=" + logLevel);
        this.commandLineArguments.add("--LogPrefix=" + processName + serviceSuffix);
        this.commandLineArguments.add("--LogPath=" + logPath.toString());
        this.commandLineArguments.add("--StdOutput=" + stdoutPath.toString());
        this.commandLineArguments.add("--StdError=" + stdoutPath.toString());
    }

    protected boolean addJreBundled() {
        Path pathToHomeParentDir;
        boolean jreBundled = false;
        Path pathToHomeDir = CommandHelper.getPathToHomeDir();
        String bundledJrePath = pathToHomeDir.toString() + File.separator + "jre";
        if (new File(bundledJrePath).exists()) {
            jreBundled = true;
        }
        if (!jreBundled && (pathToHomeParentDir = pathToHomeDir.getParent()) != null && new File(bundledJrePath = pathToHomeParentDir.toString() + File.separator + "jre").exists()) {
            jreBundled = true;
        }
        if (jreBundled) {
            this.commandLineArguments.add("--JavaHome=" + bundledJrePath);
        }
        return jreBundled;
    }

    private void addStartArguments(String pathToProperties, String startMode, boolean isVerboseLog, boolean autoStart) {
        this.commandLineArguments.add("--Startup=" + (autoStart ? "auto" : "manual"));
        this.commandLineArguments.add("--StartMode=" + startMode);
        this.commandLineArguments.add("--StartClass=" + AppServiceConstants.THIN_JAR_MAIN_CLASS);
        this.commandLineArguments.add("--StartMethod=main");
        String logLevelArg = "-PMlog.level=" + (isVerboseLog ? "DEBUG" : "INFO");
        String startParams = "service-run-internal;-p;" + pathToProperties + ";" + this.mainClassName + ";" + logLevelArg;
        log.debug("Start arguments [{}]", (Object)startParams);
        this.commandLineArguments.add("--StartParams=" + startParams);
    }

    protected void addStopArguments(String processName, String stopMode) {
        this.commandLineArguments.add("--StopMode=" + stopMode);
        this.commandLineArguments.add("--StopClass=" + AppServiceConstants.THIN_JAR_MAIN_CLASS);
        this.commandLineArguments.add("--StopMethod=main");
        String stopParams = String.join((CharSequence)";", "stop", "elasticsearch.id", processName + ".id");
        log.debug("Stop arguments [{}]", (Object)stopParams);
        this.commandLineArguments.add("--StopParams=" + stopParams);
    }

    String addVmOptions(Properties p, Path pathToVmOptions, Path homeDir) throws IOException {
        ArrayList<String> jvmArguments = new ArrayList<String>();
        CommandHelper.addVmOptions(p, pathToVmOptions, homeDir, jvmArguments);
        return "--JvmOptions=" + Joiner.on((String)";").join(jvmArguments);
    }
}

