/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command.shim;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Command;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.command.shim.ShimOptions;
import com.appdynamics.common.executor.command.shim.ShimParsedArguments;
import com.appdynamics.common.executor.command.shim.ShimToServiceRegistryCaller;
import com.appdynamics.common.framework.Loaders;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShimCommand
implements Command {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShimCommand.class);
    public static final ShimOptions SHIM_OPTIONS = new ShimOptions();
    private final ShimToServiceRegistryCaller caller;
    private final String mainExecutorClassName;

    public ShimCommand(ShimToServiceRegistryCaller caller, String mainStartClassName) {
        this.caller = caller;
        this.mainExecutorClassName = mainStartClassName;
    }

    @Override
    public Options getOptions() {
        return SHIM_OPTIONS;
    }

    @Override
    public void execute(Arguments arguments) {
        ShimParsedArguments parsedArguments = SHIM_OPTIONS.parse(arguments);
        Arguments callerOutput = this.caller.call(parsedArguments);
        try {
            Class executorMainClass = Loaders.loadClass((String)this.mainExecutorClassName, (ClassLoader)this.getClass().getClassLoader());
            Method mainMethod = executorMainClass.getDeclaredMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{callerOutput.getItems()});
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            throw new RuntimeException("Error occurred while invoking main method on [" + this.mainExecutorClassName + "]", e);
        }
    }
}

