/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.kohsuke.args4j.Option;

public class SystemPropertiesOptions {
    @Option(name="-D", aliases={"--system-property"}, required=false, metaVar="TYPE_KEY_VALUE", usage="Key=Value pairs, where both Key and Value are strings")
    private List<String> systemProperties;

    public Properties toProperties() {
        Properties properties = new Properties();
        if (this.systemProperties != null) {
            StringBuilder sb = new StringBuilder();
            for (String systemProperty : this.systemProperties) {
                sb.append(systemProperty).append("\n");
            }
            try (StringReader stringReader = new StringReader(sb.toString());){
                properties.load(stringReader);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return properties;
    }

    @Generated
    public List<String> getSystemProperties() {
        return this.systemProperties;
    }

    @Generated
    public void setSystemProperties(List<String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Generated
    public String toString() {
        return "SystemPropertiesOptions(systemProperties=" + String.valueOf(this.getSystemProperties()) + ")";
    }
}

