/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command;

import com.appdynamics.common.executor.command.AppConstants;
import com.appdynamics.common.executor.command.windows.AppServiceConstants;
import com.appdynamics.common.executor.standalone.ProxyMain;
import com.appdynamics.common.io.IoHelper;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.var.SystemPropertyResolver;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandHelper.class);

    private CommandHelper() {
    }

    public static void checkFileExists(Path path) throws IllegalArgumentException {
        log.debug("Checking for the existence of [{}]", (Object)path.toString());
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("[" + path.toString() + "] is either a directory, does not exist or does not have read permissions");
        }
    }

    public static boolean fileExists(String pathString) {
        try {
            CommandHelper.checkFileExists(Paths.get(pathString, new String[0]));
            return true;
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    public static Properties readProperties(String relativePropertyPath) throws IOException, IllegalArgumentException {
        Path pathToProperties = Paths.get(relativePropertyPath, new String[0]);
        Path absolutePathToProperties = pathToProperties.toAbsolutePath();
        CommandHelper.checkFileExists(absolutePathToProperties);
        return CommandHelper.readProperties(absolutePathToProperties);
    }

    public static Properties readProperties(Path propertyPath) throws IOException, IllegalArgumentException {
        Properties properties;
        log.debug("Loading properties file [{}]", (Object)propertyPath.toString());
        FileInputStream is = new FileInputStream(propertyPath.toFile());
        try {
            Properties p = new Properties();
            p.load(is);
            properties = p;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException("[" + propertyPath.toString() + "] does not exist", ex);
            }
            catch (SecurityException ex) {
                throw new IllegalArgumentException("[" + propertyPath.toString() + "] does not have read permissions", ex);
            }
        }
        ((InputStream)is).close();
        return properties;
    }

    public static String readProperty(Properties p, String key) throws ConfigurationException {
        String value = StringUtils.trimToNull((String)p.getProperty(key));
        log.debug("Property [{}] has value [{}]", (Object)key, (Object)value);
        if (value == null) {
            throw new ConfigurationException("Value not set for key [ " + key + "] in properties file");
        }
        return value;
    }

    public static String readLogPath(Properties p) throws ConfigurationException {
        String logPath = StringUtils.trimToNull((String)p.getProperty("ad.dw.log.path"));
        if (logPath == null) {
            throw new ConfigurationException("Value not set for key [ad.dw.log.path] in properties file");
        }
        int lastIndexOfSeparator = logPath.lastIndexOf("}");
        logPath = lastIndexOfSeparator != -1 ? logPath.substring(lastIndexOfSeparator + 2) : logPath;
        log.debug("[{}] value [{}]", (Object)"ad.dw.log.path", (Object)logPath);
        return logPath;
    }

    public static Path getPathToVmOptions(Properties p, Path directoryPath) throws ConfigurationException {
        String vmOptionFileName = CommandHelper.readProperty(p, "ad.jvm.options.name");
        return directoryPath.resolve(vmOptionFileName);
    }

    public static String getJavaExecutablePath() throws ConfigurationException {
        String javaHomeDirectory = StringUtils.trimToNull((String)System.getProperty("java.home"));
        log.debug("Java home directory [{}]", (Object)javaHomeDirectory);
        if (javaHomeDirectory == null) {
            throw new ConfigurationException("Java home not found");
        }
        String javaExecutable = javaHomeDirectory + AppConstants.BIN_JAVA;
        CommandHelper.checkFileExists(Paths.get(javaExecutable, new String[0]));
        log.debug("Java executable [{}]", (Object)javaExecutable);
        return javaExecutable;
    }

    public static Path getPathToApacheDaemonsExecutor() {
        Path pathToHomeDir = CommandHelper.getPathToHomeDir();
        Path pathToApacheDaemonsExecutor = pathToHomeDir.resolve(AppServiceConstants.AD_RELATIVE_TO_HOME_PATH);
        CommandHelper.checkFileExists(pathToApacheDaemonsExecutor);
        log.debug("Path to Apache Daemons executor [{}]", (Object)pathToApacheDaemonsExecutor);
        return pathToApacheDaemonsExecutor;
    }

    public static Path getPathToHomeDir() {
        Path pathToHomeDir;
        String appHomeDir = SystemPropertyResolver.INSTANCE.resolve("APPLICATION_HOME");
        if ((appHomeDir = Strings.emptyToNull((String)appHomeDir)) != null) {
            log.info("[{}] has been overridden to [{}]", (Object)"APPLICATION_HOME", (Object)appHomeDir);
            pathToHomeDir = Paths.get(appHomeDir, new String[0]);
            File fileOfHomeDir = pathToHomeDir.toAbsolutePath().toFile();
            if (!fileOfHomeDir.exists() || !fileOfHomeDir.isDirectory()) {
                throw new IllegalArgumentException("The Application home directory has been overridden to [" + fileOfHomeDir.toString() + " but it does not seem to exist or is not an accessible directory");
            }
        } else {
            String libDir;
            String pathToProxyMain = ProxyMain.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            try {
                libDir = URLDecoder.decode(pathToProxyMain, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("The directory that is supposed to contain the libraries is invalid [" + pathToProxyMain + "]");
            }
            Path pathToToolDir = IoHelper.createOsSpecificPath((String)libDir);
            Path pathToBinDir = pathToToolDir == null ? null : pathToToolDir.getParent();
            Path path = pathToHomeDir = pathToBinDir == null ? null : pathToBinDir.getParent();
            if (pathToHomeDir == null) {
                throw new IllegalArgumentException("[tool-executor.jar] was expected to be under [lib] directory");
            }
        }
        log.debug("Application home directory appears to be [{}]", (Object)pathToHomeDir);
        return pathToHomeDir.toAbsolutePath();
    }

    public static Path getPathToConfDir() {
        Path pathToHomeDir = CommandHelper.getPathToHomeDir();
        Path pathToConfDir = pathToHomeDir.resolve("conf" + File.separator);
        if (!Files.exists(pathToConfDir, new LinkOption[0]) || !Files.isDirectory(pathToConfDir, new LinkOption[0])) {
            throw new IllegalArgumentException("[" + pathToConfDir.toString() + "] is either a file or does not exist");
        }
        return pathToConfDir;
    }

    public static void addVmOptions(Properties p, Path pathToVmOptions, Path homeDir, List<String> commandLineArguments) throws IOException {
        String maxHeapSize = StringUtils.trimToNull((String)p.getProperty("ad.jvm.heap.max"));
        if (maxHeapSize == null) {
            throw new ConfigurationException("Value not set for key [ad.jvm.heap.max] in properties file");
        }
        String minHeapSize = StringUtils.trimToNull((String)p.getProperty("ad.jvm.heap.min"));
        if (minHeapSize == null) {
            throw new ConfigurationException("Value not set for key [ad.jvm.heap.min] in properties file");
        }
        boolean isJava9OrLater = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_9);
        commandLineArguments.add("-Xmx" + maxHeapSize);
        commandLineArguments.add("-Xms" + minHeapSize);
        List<String> lines = Files.readAllLines(pathToVmOptions, StandardCharsets.UTF_8);
        String logGcLine = null;
        for (String line : lines) {
            if (line.startsWith("-Xlog:gc") || line.startsWith("-Xloggc:")) {
                logGcLine = line;
            } else {
                commandLineArguments.add(line);
            }
            String lowerCase = line.toLowerCase();
            if (lowerCase.startsWith("-Xms".toLowerCase())) {
                throw new ConfigurationException("Heap size [-Xms] is set both in [" + pathToVmOptions.toString() + "] file and properties file");
            }
            if (!lowerCase.startsWith("-Xmx".toLowerCase())) continue;
            throw new ConfigurationException("Heap size [-Xmx] is set both in [" + pathToVmOptions.toString() + "] file and properties file");
        }
        Path logDirToCreate = null;
        if (logGcLine == null) {
            String gcLogFilePath = "logs" + File.separator + "%p-gc.log";
            String gcLogFileFullPathStr = homeDir.resolve(gcLogFilePath).toString();
            Path gcLogFileFullPath = Paths.get(gcLogFileFullPathStr, new String[0]).toAbsolutePath();
            String jvmPrefix = isJava9OrLater ? "-Xlog:gc:" : "-Xloggc:";
            log.debug("Value for key [{}] is missing. Setting to default value [{}]", (Object)jvmPrefix, (Object)gcLogFileFullPathStr);
            commandLineArguments.add(jvmPrefix + CommandHelper.escapePath(gcLogFileFullPathStr));
            logDirToCreate = gcLogFileFullPath.getParent();
        } else {
            CharSequence[] array = logGcLine.split(":");
            if (!isJava9OrLater && array.length == 2) {
                logGcValue = StringUtils.trimToNull((String)array[1]);
                if (logGcValue != null) {
                    Path gcLogFilePath = Paths.get(logGcValue, new String[0]).toAbsolutePath();
                    logDirToCreate = gcLogFilePath.getParent();
                    commandLineArguments.add(logGcLine);
                }
            } else if (array.length > 2) {
                logGcValue = StringUtils.trimToNull((String)array[2]);
                if (logGcValue != null) {
                    Path gcLogFilePath = Paths.get(logGcValue, new String[0]).toAbsolutePath();
                    logDirToCreate = gcLogFilePath.getParent();
                } else {
                    String gcLogFilePath = "logs" + File.separator + "%p-gc.log";
                    String gcLogFileFullPathStr = homeDir.resolve(gcLogFilePath).toString();
                    Path gcLogFileFullPath = Paths.get(gcLogFileFullPathStr, new String[0]).toAbsolutePath();
                    log.debug("Value for Log file path in key [{}] is missing. Setting to default value [{}]", (Object)"-Xlog:gc", (Object)gcLogFileFullPathStr);
                    array[2] = CommandHelper.escapePath(gcLogFileFullPathStr);
                    logDirToCreate = gcLogFileFullPath.getParent();
                }
                commandLineArguments.add(String.join((CharSequence)":", array));
            }
            if (logDirToCreate == null) {
                throw new ConfigurationException("[-Xlog:gc] key exists in [" + pathToVmOptions.toString() + "] file but value is not set");
            }
        }
        commandLineArguments.add(CommandHelper.appHomeSystemProperty(homeDir));
        if (logDirToCreate != null) {
            Files.createDirectories(logDirToCreate, new FileAttribute[0]);
        }
    }

    public static String appHomeSystemProperty(Path homeDir) {
        return "-DAPPLICATION_HOME=" + CommandHelper.escapePath(homeDir.toAbsolutePath().toString());
    }

    public static String escapePath(String path) {
        return SystemUtils.IS_OS_WINDOWS ? path : "\"" + path + "\"";
    }

    public static void addCommandLineArguments(Path propertyPath, Optional<Path> ymlPath, List<String> commandLineArguments) {
        commandLineArguments.add("-p");
        commandLineArguments.add(CommandHelper.escapePath(propertyPath.toString()));
        if (ymlPath.isPresent()) {
            commandLineArguments.add("-y");
            commandLineArguments.add(CommandHelper.escapePath(((Path)ymlPath.get()).toString()));
        }
    }

    public static Path[] getPropertiesFilesInConfDir() {
        File confDir = CommandHelper.getPathToConfDir().toFile();
        File[] propertiesFiles = confDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".properties");
            }
        });
        if (propertiesFiles == null) {
            return new Path[0];
        }
        Path[] pathToPropertiesFiles = new Path[propertiesFiles.length];
        int k = 0;
        for (File pidFile : propertiesFiles) {
            pathToPropertiesFiles[k++] = pidFile.toPath();
        }
        return pathToPropertiesFiles;
    }

    public static File getRelatedPropertiesFile(File pidFile, final int pid, Path confDir) {
        String pidFileName = pidFile.getName();
        int posOfExtension = pidFileName.indexOf(".id");
        final String pidFileNameMinusExtension = posOfExtension > -1 ? pidFileName.substring(0, posOfExtension) : "";
        final AtomicReference propertiesFileOfPidRef = new AtomicReference();
        try {
            Files.walkFileTree(confDir, (Set<FileVisitOption>)ImmutableSet.of(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    String processName;
                    File file = path.toFile();
                    String name = file.getName();
                    int posOfExtension = name.indexOf(".properties");
                    String string = processName = posOfExtension > -1 ? name.substring(0, posOfExtension) : "";
                    if (processName.equals(pidFileNameMinusExtension)) {
                        log.info("Found file [{}] from which pid [{}] could have originated", (Object)file.getAbsolutePath(), (Object)pid);
                        propertiesFileOfPidRef.set(file);
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (File)propertiesFileOfPidRef.get();
    }

    public static List<Integer> readPidsFromFile(Path pathToFile) {
        try {
            List<String> lines = Files.readAllLines(pathToFile, StandardCharsets.UTF_8);
            ArrayList<Integer> pids = new ArrayList<Integer>(lines.size());
            for (String line : lines) {
                if ((line = StringUtils.trimToNull((String)line)) == null) continue;
                try {
                    pids.add(Integer.parseInt(line));
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid process id [" + line + "]", ex);
                }
            }
            return pids;
        }
        catch (NoSuchFileException ex) {
            throw new IllegalArgumentException("[" + String.valueOf(pathToFile) + "] does not exist", ex);
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException("[" + String.valueOf(pathToFile) + "] does not have read permissions", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read [" + String.valueOf(pathToFile) + "]", ex);
        }
    }

    public static List<Integer> readPidsFromFile(String pathToFile) {
        return CommandHelper.readPidsFromFile(Paths.get(pathToFile, new String[0]));
    }

    public static String escapeValue(String value) {
        if (value == null || value.isEmpty() || CommandHelper.isEscaped(value)) {
            return value;
        }
        return "\"" + value + "\"";
    }

    private static boolean isEscaped(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }
}

