/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.util.Args4jHelper;
import jakarta.validation.constraints.Min;
import java.util.List;
import lombok.Generated;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class AppStopOptions
implements Options {
    public static final String OPTION_NAME = "stop";

    @Override
    public String getName() {
        return OPTION_NAME;
    }

    @Override
    public String getUsage() {
        return "stop " + Args4jHelper.extractUsage(new ParsedArguments());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean canExecute(Arguments arguments) {
        String[] items = arguments.getItems();
        return items != null && items.length > 0 && items[0].equals(OPTION_NAME);
    }

    public ParsedArguments parse(Arguments arguments) {
        ParsedArguments parsedArguments = new ParsedArguments();
        Args4jHelper.transform(arguments, parsedArguments);
        return parsedArguments;
    }

    public static class ParsedArguments {
        @Option(required=false, name="-w", aliases={"--wait-seconds"}, usage="Time in seconds to wait for process to exit after issuing graceful stop signal", metaVar="TYPE_NUMBER")
        @Min(value=0L)
        private @Min(value=0L) int gracefulStopWaitSecs = 60;
        @Option(required=false, name="-f", aliases={"--force-stop"}, usage="Stop forcibly if the process did not stop even after graceful stop signal was issued", metaVar="TYPE_BOOLEAN")
        private boolean forceStop = false;
        @Argument(usage="File names. Each file contains the process id of the process that needs to be stopped. If file names are not provided then file names ending with [.id] are read.", metaVar="TYPE_FILE_NAMES")
        private List<String> arguments;

        @Generated
        public ParsedArguments() {
        }

        @Generated
        public int getGracefulStopWaitSecs() {
            return this.gracefulStopWaitSecs;
        }

        @Generated
        public boolean isForceStop() {
            return this.forceStop;
        }

        @Generated
        public List<String> getArguments() {
            return this.arguments;
        }

        @Generated
        public void setGracefulStopWaitSecs(int gracefulStopWaitSecs) {
            this.gracefulStopWaitSecs = gracefulStopWaitSecs;
        }

        @Generated
        public void setForceStop(boolean forceStop) {
            this.forceStop = forceStop;
        }

        @Generated
        public void setArguments(List<String> arguments) {
            this.arguments = arguments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParsedArguments)) {
                return false;
            }
            ParsedArguments other = (ParsedArguments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getGracefulStopWaitSecs() != other.getGracefulStopWaitSecs()) {
                return false;
            }
            if (this.isForceStop() != other.isForceStop()) {
                return false;
            }
            List<String> this$arguments = this.getArguments();
            List<String> other$arguments = other.getArguments();
            return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParsedArguments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getGracefulStopWaitSecs();
            result = result * 59 + (this.isForceStop() ? 79 : 97);
            List<String> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AppStopOptions.ParsedArguments(gracefulStopWaitSecs=" + this.getGracefulStopWaitSecs() + ", forceStop=" + this.isForceStop() + ", arguments=" + String.valueOf(this.getArguments()) + ")";
        }
    }
}

