/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command;

import com.appdynamics.common.executor.command.AppStopCommand;
import com.appdynamics.common.executor.command.CommandHelper;
import com.appdynamics.common.framework.util.ShutdownTask;
import com.appdynamics.common.util.configuration.Sanitizer;
import com.appdynamics.common.util.exception.Exceptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppShutdownTaskCommand
extends AppStopCommand {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppShutdownTaskCommand.class);

    @Override
    protected void stopProcess(Path pathToPidFile, int givenWaitSecs, boolean forceStop, int pid) throws InterruptedException, IOException, TimeoutException {
        Path confDir = this.getPathToConfDir();
        File propertiesFileOfPid = CommandHelper.getRelatedPropertiesFile(pathToPidFile.toFile(), pid, confDir);
        int waitTimeMillis = this.callShutDownTask(pathToPidFile, propertiesFileOfPid, givenWaitSecs);
        if (waitTimeMillis > 0) {
            super.stopProcess(pathToPidFile, waitTimeMillis, true, pid);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int callShutDownTask(Path pathToPidFile, File propertiesFileOfPid, int waitSecs) {
        int waitTimeMillis = waitSecs * 1000;
        long startTimeMillis = System.currentTimeMillis();
        List<Integer> pid = CommandHelper.readPidsFromFile(pathToPidFile);
        Preconditions.checkArgument((pid.size() > 0 ? 1 : 0) != 0, (Object)("[" + String.valueOf(pathToPidFile) + "] is empty"));
        log.debug("Shutting down pid [{}]", pid);
        if (propertiesFileOfPid != null) {
            if (!this.callShutdownTaskUsingPropFile(propertiesFileOfPid, pid.get(0).intValue(), waitSecs)) return waitTimeMillis;
            File pidFile = pathToPidFile.toFile();
            log.info("Waiting for the deletion of [{}]", (Object)pidFile.getName());
            for (waitTimeMillis = (int)((long)waitTimeMillis - (System.currentTimeMillis() - startTimeMillis)); waitTimeMillis > 100 && pidFile.exists(); waitTimeMillis -= 100) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw Exceptions.rethrowAsRuntimeException((InterruptedException)e);
                }
            }
            if (!pidFile.exists()) return 0;
            return Math.max(1, waitTimeMillis);
        }
        log.info("Unable to find the properties file from which pid [{}] could have originated. Resorting to default process stop logic", pid);
        return waitTimeMillis;
    }

    @VisibleForTesting
    Path getPathToConfDir() {
        return CommandHelper.getPathToConfDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean callShutdownTaskUsingPropFile(File propertiesFileOfPid, long pid, int waitSecs) {
        log.debug("Attempting to read file [{}]", (Object)propertiesFileOfPid.getAbsolutePath());
        String hostString = null;
        String portString = null;
        try {
            Properties properties = new Properties();
            try (FileInputStream fis = new FileInputStream(propertiesFileOfPid);){
                properties.load(fis);
            }
            hostString = Sanitizer.sanitizeForUrl((String)properties.getProperty("ad.dw.http.host"));
            portString = Sanitizer.sanitizeForUrl((String)properties.getProperty("ad.dw.http.adminPort"));
            String captcha = ShutdownTask.makeCaptcha((long)pid);
            String urlString = "http://" + hostString + ":" + portString + "/tasks/shutdown?captcha=" + captcha;
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(waitSecs * 1000);
            connection.setReadTimeout(waitSecs * 1000);
            log.debug("Attempting to connect to [{} : {}]", (Object)hostString, (Object)portString);
            connection.connect();
            try {
                int responseCode = connection.getResponseCode();
                log.debug("Received [{} : {}] response from [{} : {}]", new Object[]{responseCode, connection.getResponseMessage(), hostString, portString});
                if (responseCode == 200) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                connection.disconnect();
            }
            log.warn("Graceful shutdown call did not work");
            return false;
        }
        catch (ConnectException e) {
            log.warn("Unable to connect [{}:{}]", hostString, portString);
            return false;
        }
        catch (IOException e) {
            log.warn("Graceful shutdown call did not work", (Throwable)e);
        }
        return false;
    }
}

