/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.util.Args4jHelper;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;

public class AppHealthCheckOptions
implements Options {
    public static final String OPTION_NAME = "check-health";

    @Override
    public String getName() {
        return OPTION_NAME;
    }

    @Override
    public String getUsage() {
        return "check-health " + Args4jHelper.extractUsage(new ParsedArguments());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean canExecute(Arguments arguments) {
        String[] items = arguments.getItems();
        return items != null && items.length > 0 && items[0].equals(OPTION_NAME);
    }

    public ParsedArguments parse(Arguments arguments) {
        ParsedArguments parsedArguments = new ParsedArguments();
        Args4jHelper.transform(arguments, parsedArguments);
        return parsedArguments;
    }

    public static class ParsedArguments {
        @Option(required=false, name="-p", aliases={"--properties"}, usage="Path to the properties file (Multiple values separated by space)", metaVar="TYPE_PATH", handler=StringArrayOptionHandler.class)
        List<String> pathsToProperties = new LinkedList<String>();
        @Option(required=false, name="-hp", aliases={"--host-and-port"}, usage="Application host name or IP:HTTP admin port (Multiple values separated by space)", handler=StringArrayOptionHandler.class)
        List<String> hostsAndPorts = new LinkedList<String>();
        @Option(required=false, name="-v", aliases={"--verbose"}, metaVar="TYPE_BOOLEAN", usage="Verbose output")
        boolean verbose = false;

        @Generated
        public List<String> getPathsToProperties() {
            return this.pathsToProperties;
        }

        @Generated
        public List<String> getHostsAndPorts() {
            return this.hostsAndPorts;
        }

        @Generated
        public boolean isVerbose() {
            return this.verbose;
        }

        @Generated
        public void setPathsToProperties(List<String> pathsToProperties) {
            this.pathsToProperties = pathsToProperties;
        }

        @Generated
        public void setHostsAndPorts(List<String> hostsAndPorts) {
            this.hostsAndPorts = hostsAndPorts;
        }

        @Generated
        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        @Generated
        public String toString() {
            return "AppHealthCheckOptions.ParsedArguments(pathsToProperties=" + String.valueOf(this.getPathsToProperties()) + ", hostsAndPorts=" + String.valueOf(this.getHostsAndPorts()) + ", verbose=" + this.isVerbose() + ")";
        }
    }
}

