/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common.exceptions;

import com.appdynamics.analytics.client.common.exceptions.BadRequestRestException;
import com.appdynamics.analytics.client.common.exceptions.ConflictRestException;
import com.appdynamics.analytics.client.common.exceptions.InternalServerRestException;
import com.appdynamics.analytics.client.common.exceptions.NotAcceptableRestException;
import com.appdynamics.analytics.client.common.exceptions.NotFoundRestException;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.client.common.exceptions.RestExceptionPayload;
import com.appdynamics.analytics.client.common.exceptions.UnauthorizedRestException;
import com.appdynamics.analytics.client.common.exceptions.UnavailableRestException;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestExceptionFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestExceptionFactory.class);

    public static RestException makeException(RestExceptionPayload payload) {
        return switch (payload.getStatusCode()) {
            case 400 -> new BadRequestRestException(payload);
            case 401 -> new UnauthorizedRestException(payload);
            case 404 -> new NotFoundRestException(payload);
            case 406 -> new NotAcceptableRestException(payload);
            case 409 -> new ConflictRestException(payload);
            case 500 -> new InternalServerRestException(payload);
            case 503 -> new UnavailableRestException(payload);
            default -> {
                log.debug("Unknown exception status code: {}", (Object)payload.getStatusCode());
                yield new RestException(payload);
            }
        };
    }

    public static RestException makeUnexpectedResponseException(HttpResponse response) {
        return new RestException(response.getStatusLine().getStatusCode(), "No additional information", "No additional information");
    }

    @Generated
    private RestExceptionFactory() {
    }
}

