/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.AsyncObjectResponseHandler;
import com.appdynamics.analytics.client.common.ResponseConsumer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringSuccessResponseConsumer
extends ResponseConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StringSuccessResponseConsumer.class);

    @Override
    <T> void onByteReceived(ByteBuffer buffer, AsyncObjectResponseHandler<T> asyncResponseHandler, Class<T> classType) {
        try {
            T obj = StringSuccessResponseConsumer.parseObject(buffer, classType);
            asyncResponseHandler.completeObject(obj);
        }
        catch (Exception e) {
            log.error("Failed to process received bytes as string object", (Throwable)e);
            throw e;
        }
    }

    @Override
    <T> boolean onComplete(AsyncObjectResponseHandler<T> asyncResponseHandler) {
        return true;
    }

    @Override
    Logger getLogger() {
        return log;
    }

    @Override
    public void close() {
    }

    private static <T> T parseObject(ByteBuffer buffer, Class<T> classType) {
        return classType.cast(new String(buffer.array(), buffer.position(), buffer.remaining(), StandardCharsets.UTF_8));
    }
}

