/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.exceptions.ClientException;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.client.common.exceptions.RestExceptionFactory;
import com.appdynamics.analytics.client.common.exceptions.RestExceptionPayload;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.core.Response;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public final class RestClientUtils {
    private static final String UNKNOWN_STATUS_CODE = "Unknown";
    static final Joiner URL_JOINER = Joiner.on((String)"/");
    static final String GZIP_CONTENT_TYPE = "gzip";

    public static void resolve(HttpResponse response, int expectedStatus, ObjectMapper mapper) {
        RestClientUtils.resolve(response, expectedStatus, mapper, Void.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <T> T resolve(HttpResponse response, int expectedStatus, ObjectMapper mapper, Class<T> entityClass) {
        block14: {
            Preconditions.checkArgument((response != null ? 1 : 0) != 0, (Object)"HttpResponse must NOT be null");
            try {
                Object object;
                block17: {
                    InputStream responseInput;
                    block15: {
                        T t;
                        block16: {
                            int statusCode = response.getStatusLine().getStatusCode();
                            RestClientUtils.validateResponse(response, expectedStatus, mapper, statusCode);
                            if (response.getEntity() == null || entityClass == null || entityClass.equals(Void.class)) break block14;
                            responseInput = response.getEntity().getContent();
                            if (!entityClass.isAssignableFrom(String.class)) break block15;
                            t = entityClass.cast(new String(ByteStreams.toByteArray((InputStream)responseInput), Charsets.UTF_8));
                            if (responseInput == null) break block16;
                            responseInput.close();
                        }
                        return t;
                    }
                    object = mapper.reader(entityClass).readValue(responseInput);
                    if (responseInput == null) break block17;
                    {
                        catch (Throwable throwable) {
                            try {
                                if (responseInput != null) {
                                    try {
                                        responseInput.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e1) {
                                throw new ClientException(e1);
                            }
                        }
                    }
                    responseInput.close();
                }
                return (T)object;
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <T> T resolve(HttpResponse response, int expectedStatus, ObjectMapper mapper, TypeReference<T> typeReference) {
        block12: {
            Preconditions.checkNotNull((Object)response, (Object)"response must not be null");
            Preconditions.checkNotNull((Object)mapper, (Object)"mapper can't be null");
            Preconditions.checkNotNull(typeReference, (Object)"typeReference can't be null");
            try {
                Object object;
                InputStream responseInput;
                block13: {
                    int statusCode = response.getStatusLine().getStatusCode();
                    RestClientUtils.validateResponse(response, expectedStatus, mapper, statusCode);
                    HttpEntity responseEntity = response.getEntity();
                    if (responseEntity == null) break block12;
                    responseInput = responseEntity.getContent();
                    object = mapper.readValue(responseInput, typeReference);
                    if (responseInput == null) break block13;
                    responseInput.close();
                }
                return (T)object;
                {
                    catch (Throwable throwable) {
                        try {
                            if (responseInput != null) {
                                try {
                                    responseInput.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new ClientException(e);
                        }
                    }
                }
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
        return null;
    }

    public static CloseableHttpResponse validateRawResponse(CloseableHttpResponse response, int expectedStatus, ObjectMapper mapper) {
        Preconditions.checkNotNull((Object)response, (Object)"response must not be null");
        int statusCode = response.getStatusLine().getStatusCode();
        RestClientUtils.validateResponse((HttpResponse)response, expectedStatus, mapper, statusCode);
        return response;
    }

    public static RestException consumeResponseAsRestException(@NonNull HttpEntity httpEntity, @NonNull ObjectMapper mapper) {
        RestExceptionPayload exceptionPayload;
        byte[] responseData;
        if (httpEntity == null) {
            throw new IllegalArgumentException("httpEntity is marked non-null but is null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("mapper is marked non-null but is null");
        }
        try (InputStream content = httpEntity.getContent();
             InputStream responseInput = RestClientUtils.wrapIfGzipped(httpEntity, content);){
            responseData = ByteStreams.toByteArray((InputStream)responseInput);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
        try {
            exceptionPayload = (RestExceptionPayload)mapper.readerFor(RestExceptionPayload.class).readValue(responseData);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
        return RestExceptionFactory.makeException(exceptionPayload);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T consumeResponseAs(HttpResponse response, int expectedStatus, ObjectMapper mapper, Class<T> entityClass) {
        boolean isResponseContentNotAvailable;
        Preconditions.checkNotNull((Object)mapper);
        int statusCode = response.getStatusLine().getStatusCode();
        boolean isErrorCode = RestClientUtils.isError(statusCode);
        if (!isErrorCode && expectedStatus > 0 && statusCode != expectedStatus) {
            throw RestExceptionFactory.makeUnexpectedResponseException(response);
        }
        boolean bl = isResponseContentNotAvailable = response.getEntity() == null;
        if (isResponseContentNotAvailable) {
            if (isErrorCode) {
                throw RestExceptionFactory.makeException(new RestExceptionPayload(statusCode, UNKNOWN_STATUS_CODE, "", "", Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()));
            }
            return null;
        }
        HttpEntity httpEntity = response.getEntity();
        if (isErrorCode) {
            throw RestClientUtils.consumeResponseAsRestException(httpEntity, mapper);
        }
        try (InputStream content = httpEntity.getContent();){
            T t;
            block26: {
                InputStream responseInput;
                block22: {
                    Object object;
                    block25: {
                        byte[] responseData;
                        block23: {
                            T t2;
                            block24: {
                                responseInput = RestClientUtils.wrapIfGzipped(httpEntity, content);
                                try {
                                    responseData = ByteStreams.toByteArray((InputStream)responseInput);
                                    if (Objects.equals(entityClass, Void.class)) break block22;
                                    if (!entityClass.isAssignableFrom(String.class)) break block23;
                                    t2 = entityClass.cast(new String(responseData, StandardCharsets.UTF_8));
                                    if (responseInput == null) break block24;
                                }
                                catch (Throwable throwable) {
                                    if (responseInput != null) {
                                        try {
                                            responseInput.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                responseInput.close();
                            }
                            return t2;
                        }
                        object = mapper.readerFor(entityClass).readValue(responseData);
                        if (responseInput == null) break block25;
                        responseInput.close();
                    }
                    return (T)object;
                }
                t = null;
                if (responseInput == null) break block26;
                responseInput.close();
            }
            return t;
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    private static boolean isGzippedContent(Header encoding) {
        if (encoding != null && encoding.getElements() != null) {
            for (HeaderElement headerElement : encoding.getElements()) {
                if (headerElement == null || !GZIP_CONTENT_TYPE.equalsIgnoreCase(headerElement.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static void validateResponse(HttpResponse response, int expectedStatus, ObjectMapper mapper, int statusCode) {
        if (RestClientUtils.isError(statusCode)) {
            if (response.getEntity() != null) {
                try {
                    InputStream responseInput = response.getEntity().getContent();
                    try {
                        byte[] data = IOUtils.toByteArray((InputStream)responseInput);
                        if (data.length > 0) {
                            RestExceptionPayload excData;
                            try {
                                excData = (RestExceptionPayload)mapper.reader(RestExceptionPayload.class).readValue(data);
                            }
                            catch (Exception e) {
                                throw RestExceptionFactory.makeException(new RestExceptionPayload(statusCode, UNKNOWN_STATUS_CODE, "", "", new String(data, StandardCharsets.UTF_8)));
                            }
                            excData.setStatusCode(statusCode);
                            throw RestExceptionFactory.makeException(excData);
                        }
                        throw RestExceptionFactory.makeUnexpectedResponseException(response);
                    }
                    catch (Throwable throwable) {
                        if (responseInput != null) {
                            try {
                                responseInput.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (IOException e1) {
                    throw new ClientException(e1);
                }
            }
            throw RestExceptionFactory.makeException(new RestExceptionPayload(statusCode, UNKNOWN_STATUS_CODE, "", "", Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()));
        }
        if (expectedStatus > 0 && statusCode != expectedStatus) {
            throw RestExceptionFactory.makeUnexpectedResponseException(response);
        }
    }

    public static boolean isError(int statusCode) {
        return statusCode >= 400;
    }

    public static CloseableHttpClient buildClient() {
        return HttpClients.createDefault();
    }

    public static String buildPath(String firstSegment, String secondSegment, String ... pathSegments) {
        return URL_JOINER.join((Object)firstSegment, (Object)secondSegment, (Object[])pathSegments);
    }

    private static InputStream wrapIfGzipped(HttpEntity httpEntity, InputStream content) throws IOException {
        return RestClientUtils.isGzippedContent(httpEntity.getContentEncoding()) ? new GZIPInputStream(content) : content;
    }

    @Generated
    private RestClientUtils() {
    }
}

