/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.AdvancedNHttpClientConnectionManager;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Optional;
import java.util.Set;
import org.apache.http.config.Registry;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.pool.PoolStats;

public class InstrumentedNClientConnManager
extends PoolingNHttpClientConnectionManager
implements AdvancedNHttpClientConnectionManager {
    public InstrumentedNClientConnManager(ConnectingIOReactor ioreactor, Optional<MetricRegistry> metricRegistry, String name, String metricPrefix) {
        super(ioreactor);
        this.registerMetrics(metricRegistry, name, metricPrefix);
    }

    public InstrumentedNClientConnManager(ConnectingIOReactor ioreactor, Registry<SchemeIOSessionStrategy> schemaIOSessionRegistry, Optional<MetricRegistry> metricRegistry, String name, String metricPrefix) {
        super(ioreactor, schemaIOSessionRegistry);
        this.registerMetrics(metricRegistry, name, metricPrefix);
    }

    private void registerMetrics(Optional<MetricRegistry> metricRegistry, String name, String metricPrefix) {
        if (metricRegistry.isPresent()) {
            InstrumentedNClientConnManager.registerGauge((MetricRegistry)metricRegistry.get(), MetricRegistry.name((String)metricPrefix, (String[])new String[]{name, "available-connections"}), new Gauge<Object>(){

                public Object getValue() {
                    return InstrumentedNClientConnManager.this.getTotalStats().getAvailable();
                }
            });
            InstrumentedNClientConnManager.registerGauge((MetricRegistry)metricRegistry.get(), MetricRegistry.name((String)metricPrefix, (String[])new String[]{name, "leased-connections"}), new Gauge<Object>(){

                public Object getValue() {
                    return InstrumentedNClientConnManager.this.getTotalStats().getLeased();
                }
            });
            InstrumentedNClientConnManager.registerGauge((MetricRegistry)metricRegistry.get(), MetricRegistry.name((String)metricPrefix, (String[])new String[]{name, "max-connections"}), new Gauge<Object>(){

                public Object getValue() {
                    return InstrumentedNClientConnManager.this.getTotalStats().getMax();
                }
            });
            InstrumentedNClientConnManager.registerGauge((MetricRegistry)metricRegistry.get(), MetricRegistry.name((String)metricPrefix, (String[])new String[]{name, "pending-connections"}), new Gauge<Object>(){

                public Object getValue() {
                    return InstrumentedNClientConnManager.this.getTotalStats().getPending();
                }
            });
            InstrumentedNClientConnManager.registerGauge((MetricRegistry)metricRegistry.get(), MetricRegistry.name((String)metricPrefix, (String[])new String[]{name, "sum-of-routes-specific-leased-connections"}), new Gauge<Object>(){

                public Object getValue() {
                    return InstrumentedNClientConnManager.this.getSumOfRouteSpecificLeasedConnection();
                }
            });
        }
    }

    private static <T> void registerGauge(MetricRegistry metricRegistry, String name, Gauge<T> gauge) {
        metricRegistry.remove(name);
        metricRegistry.register(name, gauge);
    }

    @Override
    public double getLeasedToMaxConnectionsRatio() {
        return (double)this.getSumOfRouteSpecificLeasedConnection() / (double)this.getTotalStats().getMax();
    }

    @Override
    public int getNumOfMaxConnection() {
        return this.getTotalStats().getMax();
    }

    @Override
    public int getSumOfRouteSpecificLeasedConnection() {
        int totalLeased = 0;
        Set routes = this.getRoutes();
        for (HttpRoute route : routes) {
            PoolStats stat = this.getStats(route);
            totalLeased += stat.getLeased();
        }
        return totalLeased;
    }
}

