/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.GenericHttpRequestBuilder;
import com.appdynamics.analytics.client.common.exceptions.ClientException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;

public class HttpEntityEnclosingRequestBuilder
extends GenericHttpRequestBuilder<HttpEntityEnclosingRequestBuilder> {
    private static final int GZIP_THRESHOLD = 200;
    static final String OVERRIDE_CONTRACT_TEST_GZIP_DISABLE = "override.contract.test.gzip.disable";
    private final HttpEntityEnclosingRequest request;
    private boolean gzipDisabled;

    protected <T extends HttpRequestBase> HttpEntityEnclosingRequestBuilder(T request) {
        super(request);
        this.request = (HttpEntityEnclosingRequest)request;
    }

    public boolean isGzipDisabled() {
        return this.gzipDisabled;
    }

    public HttpEntityEnclosingRequestBuilder setRequestEntity(Object entity) {
        return this.setRequestEntity(entity, false);
    }

    public HttpEntityEnclosingRequestBuilder setRequestEntity(Object entity, boolean gzipDisabled) {
        return this.setRequestEntity(entity, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON.getMimeType(), gzipDisabled);
    }

    public HttpEntityEnclosingRequestBuilder setRequestEntity(Object entity, ContentType contentType, String mimeType, boolean gzipDisabled) {
        byte[] bytes = entity.getClass().isAssignableFrom(String.class) ? ((String)entity).getBytes(Charsets.UTF_8) : this.getBytesFromObject(entity);
        ByteArrayEntity httpEntity = new ByteArrayEntity(bytes, contentType);
        boolean gzipOverride = Boolean.getBoolean(OVERRIDE_CONTRACT_TEST_GZIP_DISABLE);
        boolean bl = gzipDisabled = gzipDisabled || gzipOverride;
        if (!gzipDisabled && bytes.length >= 200) {
            httpEntity = new GzipCompressingEntity((HttpEntity)httpEntity);
        }
        this.request.setEntity((HttpEntity)httpEntity);
        this.request.addHeader("Content-Type", mimeType);
        this.gzipDisabled = gzipDisabled;
        return this;
    }

    private byte[] getBytesFromObject(Object entity) {
        byte[] bytes;
        this.checkNotNull(this.getMapper(), "ObjectMapper");
        try {
            bytes = this.getMapper().writer().writeValueAsBytes(entity);
        }
        catch (JsonProcessingException e1) {
            throw new ClientException("Could not serialize data of type " + String.valueOf(entity.getClass()), e1);
        }
        return bytes;
    }

    @Override
    protected HttpEntityEnclosingRequestBuilder getThis() {
        return this;
    }
}

