/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.RequestBuilderException;
import com.appdynamics.analytics.client.common.RestClientUtils;
import com.appdynamics.analytics.client.common.exceptions.ClientException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class GenericHttpRequestBuilder<T extends GenericHttpRequestBuilder<?>> {
    protected final HttpRequestBase request;
    protected URIBuilder uriBuilder;
    private ObjectMapper mapper;
    private int expectedStatusCode;
    private CloseableHttpClient client;

    protected GenericHttpRequestBuilder(HttpRequestBase request) {
        this.request = request;
        request.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try {
            this.uriBuilder = new URIBuilder("/");
        }
        catch (URISyntaxException e) {
            throw new RequestBuilderException(e);
        }
    }

    public T setUri(String uri) {
        try {
            this.uriBuilder = new URIBuilder(uri);
        }
        catch (URISyntaxException e) {
            throw new RequestBuilderException(e);
        }
        return this.getThis();
    }

    protected abstract T getThis();

    public T setUri(URI uri) {
        this.uriBuilder = new URIBuilder(uri);
        return this.getThis();
    }

    public T setPath(String path) {
        this.uriBuilder.setPath(StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
        return this.getThis();
    }

    public T appendPath(String pathSegment, String ... otherSegments) {
        String currentPath = this.uriBuilder.getPath();
        Object completePath = RestClientUtils.buildPath(currentPath, pathSegment, otherSegments);
        if (((String)completePath).charAt(0) != '/') {
            completePath = "/" + (String)completePath;
        }
        this.uriBuilder.setPath((String)completePath);
        return this.getThis();
    }

    public T addQueryParam(String name, String value) {
        this.uriBuilder.addParameter(name, value);
        return this.getThis();
    }

    public T addHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this.getThis();
    }

    public T setHeader(String name, String value) {
        this.request.setHeader(name, value);
        return this.getThis();
    }

    public T using(ObjectMapper mapper) {
        this.mapper = mapper;
        return this.getThis();
    }

    public T using(CloseableHttpClient client) {
        this.client = client;
        return this.getThis();
    }

    public T expecting(int expectedStatusCode) {
        this.expectedStatusCode = expectedStatusCode;
        return this.getThis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <U> U execute(Class<U> responseEntityClass) {
        this.checkNotNull(responseEntityClass, "Response entity class");
        try (CloseableHttpResponse response = this.getResponse();){
            U u = RestClientUtils.resolve((HttpResponse)response, this.expectedStatusCode, this.mapper, responseEntityClass);
            return u;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <U> U execute(TypeReference<U> responseEntityTypeReference) {
        this.checkNotNull(responseEntityTypeReference, "responseEntityTypeReference can't be null");
        try (CloseableHttpResponse response = this.getResponse();){
            U u = RestClientUtils.resolve((HttpResponse)response, this.expectedStatusCode, this.mapper, responseEntityTypeReference);
            return u;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public HttpUriRequest getHttpRequest() throws URISyntaxException {
        this.request.setURI(this.uriBuilder.build());
        return this.request;
    }

    public void executeExpectingNoContent() {
        try (CloseableHttpResponse response = this.getResponse();){
            RestClientUtils.resolve((HttpResponse)response, this.expectedStatusCode, this.mapper, Void.class);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public CloseableHttpResponse executeAndReturnRawResponse() {
        CloseableHttpResponse response = this.getResponse();
        return RestClientUtils.validateRawResponse(response, this.expectedStatusCode, this.mapper);
    }

    private CloseableHttpResponse getResponse() {
        CloseableHttpResponse response;
        URI uri;
        this.checkNotNull(this.client, "Client");
        this.checkNotNull(this.mapper, "ObjectMapper");
        try {
            uri = this.uriBuilder.build();
        }
        catch (URISyntaxException e1) {
            throw new RequestBuilderException("The URI for the request is incorrect. Fix before reattempting.", e1);
        }
        this.getRequest().setURI(uri);
        try {
            response = this.client.execute((HttpUriRequest)this.getRequest());
        }
        catch (IOException e) {
            throw new ClientException("Could not execute request to " + String.valueOf(uri), e);
        }
        return response;
    }

    public String executeAndReturnRawResponseString() {
        String string;
        block8: {
            CloseableHttpResponse response = this.getResponse();
            try {
                string = RestClientUtils.resolve((HttpResponse)response, this.expectedStatusCode, this.mapper, String.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            response.close();
        }
        return string;
    }

    protected void checkNotNull(Object param, String name) {
        if (param == null) {
            throw new RequestBuilderException(name + " has not been set");
        }
    }

    @Generated
    protected HttpRequestBase getRequest() {
        return this.request;
    }

    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Generated
    public int getExpectedStatusCode() {
        return this.expectedStatusCode;
    }

    @Generated
    protected CloseableHttpClient getClient() {
        return this.client;
    }
}

