/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.AsyncObjectResponseHandler;
import com.appdynamics.analytics.client.common.ResponseConsumer;
import com.appdynamics.analytics.client.common.RestClientUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import lombok.Generated;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.BasicHttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponseConsumer
extends ResponseConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorResponseConsumer.class);
    private final HttpResponse response;
    private final PipedOutputStream pipedOutputStream = new PipedOutputStream();

    ErrorResponseConsumer(@NonNull HttpResponse response) throws IOException {
        if (response == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        this.response = response;
        ((BasicHttpEntity)response.getEntity()).setContent((InputStream)new PipedInputStream(this.pipedOutputStream));
    }

    @Override
    public void close() {
        this.closeQuietly(this.pipedOutputStream);
    }

    @Override
    <T> void onByteReceived(ByteBuffer buffer, AsyncObjectResponseHandler<T> asyncResponseHandler, Class<T> classType) throws IOException {
        while (buffer.hasRemaining()) {
            if (asyncResponseHandler.isDead()) {
                return;
            }
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            this.pipedOutputStream.write(bytes);
        }
    }

    @Override
    <T> boolean onComplete(AsyncObjectResponseHandler<T> asyncResponseHandler) {
        int statusCode = this.response.getStatusLine().getStatusCode();
        HttpEntity entity = this.response.getEntity();
        if (entity == null) {
            asyncResponseHandler.failed(statusCode);
        } else {
            try {
                this.pipedOutputStream.close();
                asyncResponseHandler.failed(RestClientUtils.consumeResponseAsRestException(entity, OBJECT_MAPPER));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                asyncResponseHandler.failed(statusCode);
            }
        }
        return false;
    }

    @Override
    Logger getLogger() {
        return log;
    }
}

