/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.HttpRequestFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.beans.ConstructorProperties;
import java.net.URI;
import lombok.Generated;

public abstract class BaseAnalyticsClient {
    private static final String BASIC_AUTH_TYPE = "Basic";
    private static final String BASIC_AUTH_TEMPLATE = "Basic %s";
    public static final String HEADER_REQUESTOR_IDENTIFIER = "Requestor-Identifier";
    private final ObjectMapper mapper;
    private final HttpRequestFactory requestFactory;

    public URI getBaseURI() {
        return this.requestFactory.getBaseURI();
    }

    protected static String buildStandardAuthHeader(String accountName, String accessKey) {
        return BaseAnalyticsClient.base64EncodedAuthzHeaderValue(accountName + ":" + accessKey);
    }

    protected static String buildSystemAuthzHeader(String accessKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0);
        return BaseAnalyticsClient.base64EncodedAuthzHeaderValue(accessKey);
    }

    private static String base64EncodedAuthzHeaderValue(String opsAccessKey) {
        return String.format(BASIC_AUTH_TEMPLATE, BaseAnalyticsClient.base64Encode(opsAccessKey));
    }

    private static String base64Encode(String value) {
        return BaseEncoding.base64().encode(value.getBytes(Charsets.UTF_8));
    }

    @ConstructorProperties(value={"mapper", "requestFactory"})
    @Generated
    protected BaseAnalyticsClient(ObjectMapper mapper, HttpRequestFactory requestFactory) {
        this.mapper = mapper;
        this.requestFactory = requestFactory;
    }

    @Generated
    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    @Generated
    protected HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }
}

