/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.Response;
import com.appdynamics.analytics.client.common.exceptions.ClientException;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResponse<T>
implements Future<T>,
Response<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncResponse.class);
    private final Future<T> future;
    private final int nullResponseForHttpExceptionStatus;
    private final boolean checkForExceptionHttpStatus;

    public AsyncResponse(Future<T> future) {
        this.future = future;
        this.nullResponseForHttpExceptionStatus = -1;
        this.checkForExceptionHttpStatus = false;
    }

    public AsyncResponse(Future<T> future, int nullResponseForHttpExceptionStatus) {
        Preconditions.checkArgument((nullResponseForHttpExceptionStatus > 0 ? 1 : 0) != 0);
        this.future = future;
        this.nullResponseForHttpExceptionStatus = nullResponseForHttpExceptionStatus;
        this.checkForExceptionHttpStatus = true;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public T get() {
        try {
            T result = this.future.get();
            if (this.future.isCancelled() && result == null) {
                throw new CancellationException("The task has been cancelled");
            }
            return result;
        }
        catch (InterruptedException e) {
            throw new ClientException(e);
        }
        catch (ExecutionException e) {
            return this.handleExceptions(e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            T result = this.future.get(timeout, unit);
            if (this.future.isCancelled() && result == null) {
                throw new CancellationException("The task has been cancelled");
            }
            return result;
        }
        catch (InterruptedException e) {
            throw new ClientException(e);
        }
        catch (ExecutionException e) {
            return this.handleExceptions(e);
        }
    }

    private boolean checkIfExceptionIsSuppressed(Throwable cause) {
        if (this.checkForExceptionHttpStatus && cause != null && cause instanceof RestException) {
            RestException restEx = (RestException)cause;
            return restEx.getStatusCode() == this.nullResponseForHttpExceptionStatus;
        }
        return false;
    }

    private T handleExceptions(ExecutionException executionException) {
        Throwable cause = executionException.getCause();
        if (cause instanceof IOException) {
            throw new ClientException(cause);
        }
        if (this.checkIfExceptionIsSuppressed(cause)) {
            return null;
        }
        if (cause == null) {
            throw new RuntimeException("ExecutionException with null cause thrown by httpAsyncClient");
        }
        throw Throwables.propagate((Throwable)cause);
    }
}

