/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.GenericHttpRequestBuilder;
import com.appdynamics.analytics.client.common.RestClientUtils;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.http.ContentTooLongException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.protocol.HttpContext;

public class AsyncHttpResponseConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private static int CONTENT_LENGTH = 4096;
    private final Class<T> responseClass;
    private final GenericHttpRequestBuilder httpRequestBuilder;
    private volatile SimpleInputBuffer inputBuffer;
    private volatile HttpResponse response;

    public AsyncHttpResponseConsumer(GenericHttpRequestBuilder httpRequestBuilder, Class<T> responseClass) {
        this.responseClass = responseClass;
        this.httpRequestBuilder = httpRequestBuilder;
    }

    protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        this.response = response;
    }

    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Preconditions.checkNotNull((Object)this.inputBuffer, (Object)"Content buffer");
        this.inputBuffer.consumeContent(decoder);
    }

    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long:" + len);
        }
        if (len < 0L) {
            len = CONTENT_LENGTH;
        }
        this.inputBuffer = new SimpleInputBuffer((int)len, (ByteBufferAllocator)new HeapByteBufferAllocator());
        this.response.setEntity((HttpEntity)new ContentBufferEntity(entity, (ContentInputBuffer)this.inputBuffer));
    }

    protected T buildResult(HttpContext context) throws Exception {
        T responseData = RestClientUtils.consumeResponseAs(this.response, this.httpRequestBuilder.getExpectedStatusCode(), this.httpRequestBuilder.getMapper(), this.responseClass);
        if (this.responseClass != Void.class && responseData == null) {
            throw new RestException(500, "No data Received");
        }
        return responseData;
    }

    protected void releaseResources() {
        this.response = null;
        this.inputBuffer = null;
    }
}

