/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.BaseAnalyticsClient;
import com.appdynamics.analytics.client.common.DefaultHeadersBuilder;
import com.appdynamics.analytics.client.common.HttpRequestFactory;
import com.appdynamics.analytics.client.common.HttpRequestRetryer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalyticsClient
extends BaseAnalyticsClient
implements Closeable {
    private final CloseableHttpClient client;

    protected AbstractAnalyticsClient(ObjectMapper mapper, CloseableHttpClient client, URI baseUri) {
        super(mapper, new HttpRequestFactory(mapper, client, baseUri));
        this.client = client;
    }

    public static <T> Builder<T> builder(Class<T> clazz, String scheme, String host, int port) {
        return new Builder<T>(clazz, scheme, host, port);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Generated
    protected CloseableHttpClient getClient() {
        return this.client;
    }

    public static class Builder<T> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        private final Class<T> clazz;
        private final String scheme;
        private final String hostName;
        private final int port;
        protected ObjectMapper mapper;
        protected CloseableHttpClient client;
        protected int maxTotalConnections = 200;
        protected int maxConnectionsPerRoute = 20;
        protected int socketTimeoutMillis = 30000;
        protected int connectionTimeoutMillis = 5000;
        protected int defaultIdleConnectionTimeInMillis = 300000;
        protected SSLContext sslContext = null;
        protected String tlsVersion = null;
        protected Registry<ConnectionSocketFactory> socketFactoryRegistry;
        protected String trustStorePasswordBase64 = null;
        protected String trustStoreFile = null;
        protected String trustStoreType = null;
        protected String httpProxyHost = null;
        protected Integer httpProxyPort = null;
        protected String httpProxyUsername = null;
        protected String httpProxyPassword = null;
        protected DefaultHeadersBuilder defaultHeadersBuilder = new DefaultHeadersBuilder();
        protected boolean evictExpiredConnections = false;
        protected boolean evictIdleConnections = true;
        protected long maxIdleTimeInMillis = this.defaultIdleConnectionTimeInMillis;
        protected String cookieSpec = "default";
        protected String basePath;
        protected int retryCount = 0;
        protected boolean retryOnFailure = false;

        public Builder(Class<T> clazz, String scheme, String hostName, int port) {
            this.clazz = clazz;
            this.scheme = scheme;
            this.hostName = hostName;
            this.port = port;
        }

        public Builder<T> maxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public Builder<T> maxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
            return this;
        }

        public Builder<T> socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        public Builder<T> connectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder<T> sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder<T> setTlsVersion(String tlsVersion) {
            this.tlsVersion = tlsVersion;
            return this;
        }

        public Builder<T> trustStoreConfig(String trustStoreFile, String trustStorePasswordBase64) {
            this.trustStorePasswordBase64 = trustStorePasswordBase64;
            this.trustStoreFile = trustStoreFile;
            return this;
        }

        public Builder<T> trustStoreConfig(String trustStoreFile, String trustStorePasswordBase64, String trustStoreType) {
            this.trustStorePasswordBase64 = trustStorePasswordBase64;
            this.trustStoreFile = trustStoreFile;
            this.trustStoreType = trustStoreType;
            return this;
        }

        public Builder<T> proxyConfig(String httpProxyHost, Integer httpProxyPort, String httpProxyUsername, String httpProxyPassword) {
            this.httpProxyHost = httpProxyHost;
            this.httpProxyPort = httpProxyPort;
            this.httpProxyUsername = httpProxyUsername;
            this.httpProxyPassword = httpProxyPassword;
            return this;
        }

        public Builder<T> requestorIdentifierHeader(String requestorIdentifierDefaultValue) {
            this.defaultHeadersBuilder.upsertHeader("Requestor-Identifier", requestorIdentifierDefaultValue);
            return this;
        }

        public Builder<T> evictExpiredConnections() {
            return this.evictExpiredConnections(true);
        }

        public Builder<T> evictExpiredConnections(boolean evictExpiredConnections) {
            this.evictExpiredConnections = evictExpiredConnections;
            return this;
        }

        public Builder<T> evictIdleConnections(long maxIdleTimeInMillis) {
            return this.evictIdleConnections(true, maxIdleTimeInMillis);
        }

        public Builder<T> evictIdleConnections(boolean evictIdleConnections, long maxIdleTimeInMillis) {
            this.evictIdleConnections = evictIdleConnections;
            this.maxIdleTimeInMillis = maxIdleTimeInMillis;
            return this;
        }

        public Builder<T> evictIdleConnections(boolean evictIdleConnections) {
            this.evictIdleConnections = evictIdleConnections;
            return this;
        }

        public Builder<T> socketFactoryRegistry(Registry<ConnectionSocketFactory> socketFactoryRegistry) {
            this.socketFactoryRegistry = socketFactoryRegistry;
            return this;
        }

        public Builder<T> retryOnFailure(int retryCount) {
            this.retryOnFailure = true;
            this.retryCount = retryCount;
            return this;
        }

        public Builder<T> retryOnFailureOnce() {
            this.retryOnFailure = true;
            this.retryCount = 1;
            return this;
        }

        public Builder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder<T> client(CloseableHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder<T> cookieSpec(String cookieSpec) {
            this.cookieSpec = cookieSpec;
            return this;
        }

        public Builder<T> basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public T build() {
            if (this.mapper == null) {
                this.mapper = new ObjectMapper();
            }
            if (this.client == null) {
                this.client = this.createClient();
            }
            return this.buildInternal();
        }

        private CloseableHttpClient createClient() {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(this.getSocketFactoryRegistry());
            connectionManager.setMaxTotal(this.maxTotalConnections);
            connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
            connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.socketTimeoutMillis).build());
            HttpClientBuilder builder = HttpClients.custom();
            builder.setSSLContext(this.sslContext).setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build()).setDefaultRequestConfig(this.getRequestConfig()).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultHeaders(this.defaultHeadersBuilder.build());
            if (this.evictExpiredConnections) {
                builder.evictExpiredConnections();
            }
            if (this.evictIdleConnections) {
                builder.evictIdleConnections(this.maxIdleTimeInMillis, TimeUnit.MILLISECONDS);
            }
            if (this.retryOnFailure) {
                builder.setRetryHandler((HttpRequestRetryHandler)new HttpRequestRetryer(this.retryCount, true));
            }
            this.addProxyConfig(builder);
            return builder.build();
        }

        private void addProxyConfig(HttpClientBuilder builder) {
            if (!Strings.isNullOrEmpty((String)this.httpProxyHost) && this.httpProxyPort != null) {
                HttpHost proxy = new HttpHost(this.httpProxyHost, this.httpProxyPort.intValue());
                builder.setProxy(proxy);
                if (!Strings.isNullOrEmpty((String)this.httpProxyUsername) && !Strings.isNullOrEmpty((String)this.httpProxyPassword)) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.httpProxyUsername, this.httpProxyPassword);
                    credsProvider.setCredentials(new AuthScope(this.httpProxyHost, this.httpProxyPort.intValue()), (Credentials)credentials);
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
            }
        }

        protected RequestConfig getRequestConfig() {
            return RequestConfig.custom().setSocketTimeout(this.socketTimeoutMillis).setConnectTimeout(this.connectionTimeoutMillis).setConnectionRequestTimeout(this.connectionTimeoutMillis * 2).setCookieSpec(this.cookieSpec).build();
        }

        private Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
            if (this.socketFactoryRegistry == null) {
                RegistryBuilder builder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
                this.configureHttps((RegistryBuilder<ConnectionSocketFactory>)builder);
                this.socketFactoryRegistry = builder.build();
            }
            return this.socketFactoryRegistry;
        }

        private void configureHttps(RegistryBuilder<ConnectionSocketFactory> builder) {
            if (this.sslContext == null) {
                try {
                    this.sslContext = this.buildSslContextFromTrustStoreOrDefault();
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            builder.register("https", (Object)new SSLConnectionSocketFactory(this.sslContext));
        }

        private static char[] base64ToClearAscii(String optBase64String) {
            if (optBase64String == null || optBase64String.length() == 0) {
                return null;
            }
            byte[] clearTxtPassword = BaseEncoding.base64().decode((CharSequence)optBase64String);
            return new String(clearTxtPassword, StandardCharsets.US_ASCII).toCharArray();
        }

        private static void clearArray(char[] chars) {
            if (chars != null) {
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = '\u0000';
                }
            }
        }

        private SSLContext buildSslContextFromTrustStoreOrDefault() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
            if (Strings.isNullOrEmpty((String)this.tlsVersion)) {
                log.info("TLS version was not specified, making it by default to TLSv1.2");
                this.tlsVersion = "TLSv1.2";
            }
            if (Strings.isNullOrEmpty((String)this.trustStoreFile) || Strings.isNullOrEmpty((String)this.trustStorePasswordBase64)) {
                return this.buildSSlContextFromDefaultTrustStore();
            }
            return this.buildSSlContextFromCustomTrustStore();
        }

        private SSLContext buildSSlContextFromDefaultTrustStore() throws NoSuchAlgorithmException, KeyManagementException {
            return this.getSSLContext(null);
        }

        private SSLContext buildSSlContextFromCustomTrustStore() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, KeyManagementException {
            if (Strings.isNullOrEmpty((String)this.trustStoreType)) {
                this.trustStoreType = "JKS";
                log.debug("No trust store type is specified, using default type: {}", (Object)this.trustStoreType);
            }
            log.info("Trust store used is [{}] and of type: {}", (Object)this.trustStoreFile, (Object)this.trustStoreType);
            return this.getSSLContext(new TrustManager[]{this.getTrustManager(this.getCustomKeyStore())});
        }

        private X509TrustManager getTrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            X509TrustManager trustManager = null;
            for (TrustManager tempTrustManager : trustManagerFactory.getTrustManagers()) {
                if (!(tempTrustManager instanceof X509TrustManager)) continue;
                trustManager = (X509TrustManager)tempTrustManager;
            }
            return trustManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyStore getCustomKeyStore() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
            KeyStore customKeyStore;
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.trustStorePasswordBase64) ? 1 : 0) != 0);
            char[] password = Builder.base64ToClearAscii(this.trustStorePasswordBase64);
            FileInputStream trustStoreStream = null;
            try {
                trustStoreStream = new FileInputStream(this.trustStoreFile);
                customKeyStore = KeyStore.getInstance(this.trustStoreType);
                customKeyStore.load(trustStoreStream, password);
                log.info("Trust store [{}] is in use for HTTPS", (Object)this.trustStoreFile);
            }
            finally {
                if (null != trustStoreStream) {
                    ((InputStream)trustStoreStream).close();
                }
                Builder.clearArray(password);
            }
            return customKeyStore;
        }

        private SSLContext getSSLContext(TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
            SSLContext sslContext = SSLContext.getInstance(this.tlsVersion);
            SSLParameters sslParams = new SSLParameters();
            sslParams.setProtocols(new String[]{"TLSv1.3", "TLSv1.2"});
            sslContext.init(null, trustManagers, null);
            sslContext.getDefaultSSLParameters().setProtocols(sslParams.getProtocols());
            String client_protocol = sslContext.getProtocol();
            log.debug("[trustStoreFile or trustStorePassword is not Null] TLS version from property file: {}, Client TLS Protocol: {}", (Object)this.tlsVersion, (Object)client_protocol);
            return sslContext;
        }

        protected T buildInternal() {
            URI baseUri = this.buildBaseUri(this.basePath);
            try {
                Constructor<T> constructor = this.clazz.getDeclaredConstructor(ObjectMapper.class, CloseableHttpClient.class, URI.class);
                constructor.setAccessible(true);
                return constructor.newInstance(this.mapper, this.client, baseUri);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Could not create client with input arguments. Need (in this order): ObjectMapper, CloseableHttpClient, URI", e);
            }
        }

        protected URI buildBaseUri(String path) {
            try {
                URIBuilder builder = new URIBuilder();
                builder.setScheme(this.scheme).setHost(this.hostName).setPath(path);
                if (this.port != 80 && this.port != 443) {
                    builder.setPort(this.port);
                }
                return builder.build();
            }
            catch (URISyntaxException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

