/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.shared.rest.client.eventservice;

import com.appdynamics.analytics.client.common.AbstractAnalyticsClient;
import com.appdynamics.analytics.client.common.DropwizardClient;
import com.appdynamics.analytics.client.common.HttpEntityEnclosingRequestBuilder;
import com.appdynamics.analytics.client.common.HttpRequestBuilder;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.shared.rest.client.eventservice.ExtractedFieldsClient;
import com.appdynamics.analytics.shared.rest.dto.ExtractedFieldDefinition;
import com.appdynamics.analytics.shared.rest.dto.log.FieldExtractionLog;
import com.appdynamics.analytics.shared.rest.dto.log.LogFieldNameRecommendationEntity;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExtractedFieldsClient
extends DropwizardClient
implements ExtractedFieldsClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultExtractedFieldsClient.class);
    private static final String BASE_URI = "/v1/events";

    public DefaultExtractedFieldsClient(ObjectMapper mapper, CloseableHttpClient client, URI baseUri) {
        super(mapper, client, baseUri);
    }

    public static AbstractAnalyticsClient.Builder<DefaultExtractedFieldsClient> builder(String scheme, String hostName, int port) {
        return AbstractAnalyticsClient.builder(DefaultExtractedFieldsClient.class, (String)scheme, (String)hostName, (int)port).basePath(BASE_URI);
    }

    public static AbstractAnalyticsClient.Builder<DefaultExtractedFieldsClient> builder(String scheme, String hostName, int port, String subDomain) {
        if (subDomain == null || subDomain.isEmpty()) {
            return DefaultExtractedFieldsClient.builder(scheme, hostName, port);
        }
        log.debug("event service subdomain provided: [{}]", (Object)subDomain);
        return AbstractAnalyticsClient.builder(DefaultExtractedFieldsClient.class, (String)scheme, (String)hostName, (int)port).basePath(subDomain + BASE_URI);
    }

    @Override
    public List<ExtractedFieldDefinition> getExtractedFields(String accountName, String accessKey, String eventType) {
        String response = (String)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath(eventType, new String[]{"extracted-fields"})).addHeader("Authorization", DefaultExtractedFieldsClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).execute(String.class);
        return this.jsonToListExtractedFields(response);
    }

    @Override
    public ExtractedFieldDefinition getExtractedField(String accountName, String accessKey, String eventType, String fieldName) {
        try {
            String response = (String)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath(eventType, new String[]{"extracted-fields", fieldName})).addHeader("Authorization", DefaultExtractedFieldsClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).execute(String.class);
            return (ExtractedFieldDefinition)this.getMapper().readValue(response, ExtractedFieldDefinition.class);
        }
        catch (Exception e) {
            if (e instanceof RestException && ((RestException)((Object)e)).getStatusCode() == 204) {
                return null;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public List<ExtractedFieldDefinition> getExtractedFields(String accountName, String accessKey, String eventType, List<String> sourceTypes) {
        return this.getExtractedFields(accountName, accessKey, eventType, sourceTypes, false);
    }

    @Override
    public List<ExtractedFieldDefinition> getExtractedFields(String accountName, String accessKey, String eventType, List<String> sourceTypes, boolean includeSoftDeleted) {
        HttpRequestBuilder builder = (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath(eventType, new String[]{"extracted-fields"})).addQueryParam("includeSoftDeleted", String.valueOf(includeSoftDeleted))).addHeader("Authorization", DefaultExtractedFieldsClient.buildStandardAuthHeader((String)accountName, (String)accessKey));
        if (sourceTypes != null) {
            for (String sourceType : sourceTypes) {
                builder.addQueryParam("source-types", sourceType);
            }
        }
        String response = (String)((HttpRequestBuilder)builder.expecting(200)).execute(String.class);
        return this.jsonToListExtractedFields(response);
    }

    @Override
    public void validateExtractedField(String accountName, String accessKey, String eventType, ExtractedFieldDefinition extractedField) {
        ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"extracted-fields", extractedField.getName(), "validate"})).addHeader("Authorization", DefaultExtractedFieldsClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)extractedField).expecting(204)).executeExpectingNoContent();
    }

    @Override
    public void createExtractedField(String accountName, String accessKey, String eventType, ExtractedFieldDefinition extractedField) {
        ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"extracted-fields", extractedField.getName()})).addHeader("Authorization", DefaultExtractedFieldsClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)extractedField).expecting(204)).executeExpectingNoContent();
    }

    @Override
    public void updateExtractedField(String accountName, String accessKey, String eventType, ExtractedFieldDefinition extractedField) {
        ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().put().appendPath(eventType, new String[]{"extracted-fields", extractedField.getName()})).addHeader("Authorization", DefaultExtractedFieldsClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)extractedField).expecting(204)).executeExpectingNoContent();
    }

    @Override
    public void deleteExtractedField(String accountName, String accessKey, String eventType, String name) {
        ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().delete().appendPath(eventType, new String[]{"extracted-fields", name})).addHeader("Authorization", DefaultExtractedFieldsClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(204)).executeExpectingNoContent();
    }

    @Override
    public String inferRegex(String accountName, String accessKey, String eventType, List<FieldExtractionLog> logs) {
        return (String)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"extracted-fields", "regex"})).addHeader("Authorization", DefaultExtractedFieldsClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity(logs).expecting(200)).execute(String.class);
    }

    @Override
    public String inferFieldName(String accountName, String accessKey, String eventType, LogFieldNameRecommendationEntity requestBody) {
        return (String)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"extracted-fields", "field-name"})).addHeader("Authorization", DefaultExtractedFieldsClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)requestBody).expecting(200)).execute(String.class);
    }

    private List<ExtractedFieldDefinition> jsonToListExtractedFields(String json) {
        try {
            ObjectMapper mapper = this.getMapper();
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, ExtractedFieldDefinition.class));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

