/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property.provider;

import com.appdynamics.common.util.configuration.property.provider.ReadOnlyConfiguration;
import com.google.common.collect.ImmutableSet;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemVariableConfiguration
extends ReadOnlyConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemVariableConfiguration.class);
    private static final String SYSTEM_PROCESS_ID_KEY = "system.process.id";
    private static final String SYSTEM_HOST_NAME_KEY = "system.host.name";
    private static final Set<String> KEYS = ImmutableSet.of((Object)"system.process.id", (Object)"system.host.name");
    private static final long HOST_NAME_CACHE_TIME_NANOS = 5000000000L;
    private static final Long PROCESS_ID;
    private static volatile String hostName;
    private static volatile long hostNameResolvedAtNanos;

    public boolean containsKey(String key) {
        return KEYS.contains(key);
    }

    public Object getProperty(String key) {
        switch (key) {
            case "system.process.id": {
                return PROCESS_ID;
            }
            case "system.host.name": {
                return SystemVariableConfiguration.getHostName();
            }
        }
        return null;
    }

    public Iterator<String> getKeys() {
        return KEYS.iterator();
    }

    public static String getHostName() {
        long timeNanos = System.nanoTime();
        if (hostName == null || timeNanos - hostNameResolvedAtNanos > 5000000000L) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                String canonicalHostName = localHost.getCanonicalHostName();
                hostName = canonicalHostName = canonicalHostName.equals(localHost.getHostAddress()) ? localHost.getHostName() : canonicalHostName;
            }
            catch (UnknownHostException e) {
                hostName = "localhost";
            }
            hostNameResolvedAtNanos = timeNanos;
        }
        return hostName;
    }

    static {
        String pidStr = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        long pid = 0L;
        try {
            pid = Long.parseLong(pidStr);
        }
        catch (NumberFormatException e) {
            log.warn("Process id could not be extracted", (Throwable)e);
        }
        PROCESS_ID = pid;
    }
}

