/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property.provider;

import com.appdynamics.common.util.configuration.property.provider.ExtensionConfiguration;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class FileIncludeConfiguration
extends ExtensionConfiguration {
    private static final String FILE_INCLUDE_KEY = "include.file";

    public FileIncludeConfiguration() {
        super(FILE_INCLUDE_KEY);
    }

    public Object getProperty(String key) {
        String filePath = this.getExtension(key);
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(String.format("The path [%s] does not point to a valid file", filePath));
        }
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("An error occurred while reading lines from the file [%s]", filePath), e);
        }
    }
}

